/*
 * Samsung API
 * Copyright (c) 2009-2015 Samsung Electronics Co., Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */



#include <tizen.h>

#include "log.h"
#include "thread.h"
#include "main.h"
#include "stopwatch.h"



extern void thread_job(void *data, Ecore_Thread *thread)
{
	appdata_s *ad = NULL;
	viewdata_s *vd = NULL;
	int iteration = 0;

	ret_if(!data);
	ret_if(!thread);

	ad = data;
	vd = ad->vd;

	for (iteration = 0; ; iteration++)
	{
		vd->elapsedTime = ecore_time_get() - vd->startTime;
		ecore_thread_feedback(thread, (void*)(uintptr_t)iteration);
		usleep(10000); // You can have some real computation done…
		if (ecore_thread_check(thread)) break;
   }
}



extern void thread_job_notify(void *data, Ecore_Thread *thread, void *msg)
{
	appdata_s *ad = NULL;
	viewdata_s *vd = NULL;
	double time = 0;
	char buf[PATH_MAX] = "";

	ret_if(!data);

	ad = data;
	vd = ad->vd;
	time = vd->elapsedTime;

	time = time * 100;

	vd->lmsec = (long)(time) % 100;
	vd->lsec = (long)(time / 100) % 60;
	vd->lmin = (long)((time / 100)/60) % 60;
	vd->lhour = (long)(((time / 100)/60)/60) % 60;

	tizen_error_e result = TIZEN_ERROR_UNKNOWN;

	/* stopwatch end */
	if (vd->lhour == 59 && vd->lmin == 59 && vd->lsec == 59 && vd->lmsec == 99) {
		result = stopwatch_stop_cb(ad);
		retm_if(TIZEN_ERROR_NONE != result, "Failed to stopwatch stop: %d", result);
	}

	/* text set */
    sprintf(buf,"%s%02ld%s%02ld%s%02ld%s","<font_size=105><color=#ffffff>", vd->lhour,":",vd->lmin,":", vd->lsec, "</color></font_size>");
	elm_object_text_set(vd->time, buf);
    sprintf(buf,"%s%02ld%s","<font_size=50><color=#ffffff>.", vd->lmsec, "</color></font_size>");
    elm_object_text_set(vd->msec, buf);
}



extern void thread_job_end(void *data, Ecore_Thread *thread)
{
   _D("Thread has normally ended.");
}
/* End of file */
