/*
 * Samsung API
 * Copyright (c) 2009-2015 Samsung Electronics Co., Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __SAMPLE_SYSTEM_INFO_H__
#define __SAMPLE_SYSTEM_INFO_H__

#include <app.h>
#include <Elementary.h>
#include <system_settings.h>
#include <efl_extension.h>
#include <system_info.h>

#include <strings.h>
#include <stdlib.h>
#include <stdbool.h>
#include "log.h"


#if !defined(PACKAGE)
#define PACKAGE "org.tizen.sample_system_info"
#endif

#define HAPI __attribute__((visibility("hidden")))

#define MAX_STR 128

typedef struct appdata{
	Evas_Object* win;
	Evas_Object* navi;
	Evas_Object* conform;
} appdata_s;

typedef struct _item_data_s
{
	 int index;
	 Elm_Object_Item *item;
} item_data_s;

void gc_gl_del_cb(void *data, Evas_Object *obj);
void gc_gl_selected_cb(void *data, Evas_Object *obj, void *event_info);

void camera_list_cb(void *data, Evas_Object *obj, void *event_info);
void input_list_cb(void *data, Evas_Object *obj, void *event_info);
void location_list_cb(void *data, Evas_Object *obj, void *event_info);
void network_list_cb(void *data, Evas_Object *obj, void *event_info);
void opengl_list_cb(void *data, Evas_Object *obj, void *event_info);
void platform_list_cb(void *data, Evas_Object *obj, void *event_info);
void screen_list_cb(void *data, Evas_Object *obj, void *event_info);
void sensors_list_cb(void *data, Evas_Object *obj, void *event_info);
void speech_list_cb(void *data, Evas_Object *obj, void *event_info);
void usb_list_cb(void *data, Evas_Object *obj, void *event_info);
void vision_list_cb(void *data, Evas_Object *obj, void *event_info);
void system_list_cb(void *data, Evas_Object *obj, void *event_info);
void others_list_cb(void *data, Evas_Object *obj, void *event_info);

#endif /* __sample_system_info_H__ */
