/*
 * Samsung API
 * Copyright (c) 2009-2015 Samsung Electronics Co., Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "sample_system_info.h"

static struct platform_info {
	char *description;
	char *feature_key;
} s_platform_info[] = {
		{"CPU",	NULL},
		{"CPU ARMv6",	"http://tizen.org/feature/platform.core.cpu.arch.armv6"},
		{"CPU ARMv7",	"http://tizen.org/feature/platform.core.cpu.arch.armv7"},
		{"CPU x86",	"http://tizen.org/feature/platform.core.cpu.arch.x86"},
		{"FPU",	NULL},
		{"FPU SSE2",	"http://tizen.org/feature/platform.core.fpu.arch.sse2"},
		{"FPU SSE3",	"http://tizen.org/feature/platform.core.fpu.arch.sse3"},
		{"FPU SSSE3",	"http://tizen.org/feature/platform.core.fpu.arch.ssse3"},
		{"FPU VFPV2",	"http://tizen.org/feature/platform.core.fpu.arch.vfpv2"},
		{"FPU VFPV3",	"http://tizen.org/feature/platform.core.fpu.arch.vfpv3"},
		{"Version",	NULL},
		{"Native API Version",	"http://tizen.org/feature/platform.native.api.version"},
		{"Platform Version",	"http://tizen.org/feature/platform.version"},
		{"Web API Version",	"http://tizen.org/feature/platform.web.api.version"},
};


static char *_gl_text_get_cb(void *data, Evas_Object *obj, const char *part)
{
	item_data_s *id = (item_data_s *)data;
	char buf[MAX_STR] = {0,};
	int ret = -1;
	bool value_b = 0;
	char *value_s = NULL;

	if (!id) {
		return NULL;
	}

	if (!strcmp(part, "elm.text")) {
		return strdup(s_platform_info[id->index].description);
	} else if (!strcmp(part, "elm.text.sub")) {
		if (id->index < 10) {
			ret = system_info_get_platform_bool(s_platform_info[id->index].feature_key, &value_b);
			if (ret != SYSTEM_INFO_ERROR_NONE) {
				return NULL;
			}
			snprintf(buf, MAX_STR, "%s", value_b ? "Supported" : "Not Supported");
			return strdup(buf);
		} else {
			ret = system_info_get_platform_string(s_platform_info[id->index].feature_key, &value_s);
			if (ret != SYSTEM_INFO_ERROR_NONE) {
				return NULL;
			}
			return value_s;
		}
	}

	return NULL;
}

HAPI void platform_list_cb(void *data, Evas_Object *obj, void *event_info)
{
	appdata_s *ad = (appdata_s *)data;
	Evas_Object *clist = NULL;
	Evas_Object *navi = ad->navi;
	Elm_Genlist_Item_Class *itc = elm_genlist_item_class_new();
	Elm_Genlist_Item_Class *itc2 = elm_genlist_item_class_new();
	Elm_Object_Item *item = NULL;
	Elm_Object_Item *it  = elm_list_selected_item_get(obj);
	int i;

	elm_list_item_selected_set(it, EINA_FALSE);

	if (!navi) {
		_E("[platform_list_cb] navi is NULL");
		elm_genlist_item_class_free(itc);
		return;
	}

	clist = elm_genlist_add(navi);

	if (!clist) {
		_E("[platform_list_cb] clist is NULL");
		elm_genlist_item_class_free(itc);
		return;
	}

	itc->item_style = "group_index";
	itc->func.content_get = NULL;
	itc->func.text_get = _gl_text_get_cb;
	itc->func.del = gc_gl_del_cb;

	itc2->item_style = "double_label";
	itc2->func.content_get = NULL;
	itc2->func.text_get = _gl_text_get_cb;
	itc2->func.del = gc_gl_del_cb;

	elm_genlist_block_count_set(clist, 14);
	elm_genlist_mode_set(clist, ELM_LIST_COMPRESS);
	evas_object_smart_callback_add(clist, "selected", gc_gl_selected_cb, NULL);

	for(i=0; i<14; i++) {
		item_data_s *id = malloc(sizeof(item_data_s));
		id->index = i;
		if (s_platform_info[id->index].feature_key == NULL) {
			item = elm_genlist_item_append(clist, itc, id, NULL, ELM_GENLIST_ITEM_NONE, NULL, id);
		} else {
			item = elm_genlist_item_append(clist, itc2, id, NULL, ELM_GENLIST_ITEM_NONE, NULL, id);
		}
		id->item = item;
	}

	elm_genlist_item_class_free(itc);

	elm_naviframe_item_push(navi, "Platform", NULL, NULL, clist, NULL);
}
