/*
 * Samsung API
 * Copyright (c) 2009-2015 Samsung Electronics Co., Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "sample_system_info.h"

static struct screen_info {
	char *description;
	char *feature_key;
} s_screen_info[] = {
		{"Bits per Pixel",				"http://tizen.org/feature/screen.bpp"},
		{"Dot per Inch",				"http://tizen.org/feature/screen.dpi"},
		{"Height",						"http://tizen.org/feature/screen.height"},
		{"Width",						"http://tizen.org/feature/screen.width"},
		{"Auto Rotaion",				"http://tizen.org/feature/screen.auto_rotation"},
		{"Large Screen for coordinate",	"http://tizen.org/feature/screen.coordinate_system.size.large"},
		{"Normal Screen for coordinate","http://tizen.org/feature/screen.coordinate_system.size.normal"},
		{"HDMI",						"http://tizen.org/feature/screen.output.hdmi"},
		{"RCA",							"http://tizen.org/feature/screen.output.rca"},
		{"Large Screen Size",			"http://tizen.org/feature/screen.size.large"},
		{"Normal Screen Size",			"http://tizen.org/feature/screen.size.normal"},
		{"All Resolution",				"http://tizen.org/feature/screen.size.all"},
};

static char *_gl_text_get_cb(void *data, Evas_Object *obj, const char *part)
{
	item_data_s *id = (item_data_s *)data;
	char buf[MAX_STR] = {0,};
	int ret = -1;
	bool value_b = 0;
	int value_i;

	if (!id) {
		return NULL;
	}

	if (!strcmp(part, "elm.text")) {
		return strdup(s_screen_info[id->index].description);
	} else if (!strcmp(part, "elm.text.sub")) {
		if (id->index < 4) {
			ret = system_info_get_platform_int(s_screen_info[id->index].feature_key, &value_i);
			if (ret != SYSTEM_INFO_ERROR_NONE) {
				return NULL;
			}
			snprintf(buf, MAX_STR, "%d", value_i);
			return strdup(buf);
		} else {
			ret = system_info_get_platform_bool(s_screen_info[id->index].feature_key, &value_b);
			if (ret != SYSTEM_INFO_ERROR_NONE) {
				return NULL;
			}
			snprintf(buf, MAX_STR, "%s", value_b ? "Supported" : "Not Supported");
			return strdup(buf);
		}
	}

	return NULL;
}

HAPI void screen_list_cb(void *data, Evas_Object *obj, void *event_info)
{
	appdata_s *ad = (appdata_s *)data;
	Evas_Object *clist = NULL;
	Evas_Object *navi = ad->navi;
	Elm_Genlist_Item_Class *itc = elm_genlist_item_class_new();
	Elm_Object_Item *item = NULL;
	Elm_Object_Item *it  = elm_list_selected_item_get(obj);
	int i;

	elm_list_item_selected_set(it, EINA_FALSE);

	if (!navi) {
		_E("[screen_list_cb] navi is NULL");
		elm_genlist_item_class_free(itc);
		return;
	}

	clist = elm_genlist_add(navi);

	if (!clist) {
		_E("[screen_list_cb] clist is NULL");
		elm_genlist_item_class_free(itc);
		return;
	}

	itc->item_style = "double_label";
	itc->func.content_get = NULL;
	itc->func.text_get = _gl_text_get_cb;
	itc->func.del = gc_gl_del_cb;

	elm_genlist_block_count_set(clist, 14);
	elm_genlist_mode_set(clist, ELM_LIST_COMPRESS);
	evas_object_smart_callback_add(clist, "selected", gc_gl_selected_cb, NULL);

	for (i=0; i<12; i++) {
		item_data_s *id = malloc(sizeof(item_data_s));
		id->index = i;
		item = elm_genlist_item_append(clist, itc, id, NULL, ELM_GENLIST_ITEM_NONE, NULL, id);
		id->item = item;
	}

	elm_genlist_item_class_free(itc);

	elm_naviframe_item_push(navi, "Screen", NULL, NULL, clist, NULL);
}
