/*
 * Samsung API
 * Copyright (c) 2009-2015 Samsung Electronics Co., Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "sample_system_info.h"

static struct speech_info {
	char *description;
	char *feature_key;
} s_speech_info[] = {
		{"STT", "http://tizen.org/feature/speech.recognition"},
		{"TTS", "http://tizen.org/feature/speech.synthesis"},
};

static char *_gl_text_get_cb(void *data, Evas_Object *obj, const char *part)
{
	item_data_s *id = (item_data_s *)data;
	char buf[MAX_STR] = {0,};
	int ret = -1;
	bool value = 0;

	if (!id) {
		return NULL;
	}

	if (!strcmp(part, "elm.text")) {
		return strdup(s_speech_info[id->index].description);
	} else if (!strcmp(part, "elm.text.sub")) {
		ret = system_info_get_platform_bool(s_speech_info[id->index].feature_key, &value);

		if (ret != SYSTEM_INFO_ERROR_NONE) {
			return NULL;
		}

		snprintf(buf, MAX_STR, "%s", value ? "Supported" : "Not Supported");
		return strdup(buf);
	}

	return NULL;
}

HAPI void speech_list_cb(void *data, Evas_Object *obj, void *event_info)
{
	appdata_s *ad = (appdata_s *)data;
	Evas_Object *clist = NULL;
	Evas_Object *navi = ad->navi;
	Elm_Genlist_Item_Class *itc = elm_genlist_item_class_new();
	Elm_Object_Item *item = NULL;
	Elm_Object_Item *it  = elm_list_selected_item_get(obj);
	int i;

	elm_list_item_selected_set(it, EINA_FALSE);

	if (!navi) {
		_E("[speech_list_cb] navi is NULL");
		elm_genlist_item_class_free(itc);
		return;
	}

	clist = elm_genlist_add(navi);

	if (!clist) {
		_E("[speech_list_cb] clist is NULL");
		elm_genlist_item_class_free(itc);
		return;
	}

	itc->item_style = "double_label";
	itc->func.content_get = NULL;
	itc->func.text_get = _gl_text_get_cb;
	itc->func.del = gc_gl_del_cb;

	elm_genlist_block_count_set(clist, 14);
	elm_genlist_mode_set(clist, ELM_LIST_COMPRESS);
	evas_object_smart_callback_add(clist, "selected", gc_gl_selected_cb, NULL);

	for (i=0; i<2; i++) {
		item_data_s *id = malloc(sizeof(item_data_s));
		id->index = i;
		item = elm_genlist_item_append(clist, itc, id, NULL, ELM_GENLIST_ITEM_NONE, NULL, id);
		id->item = item;
	}

	elm_genlist_item_class_free(itc);

	elm_naviframe_item_push(navi, "Speech", NULL, NULL, clist, NULL);
}
