#include "$(appName).h"
#include "item.h"


app_item_t *item_create(const char *app_id, const char *icon_path)
{
	app_item_t *item;

	if (!app_id || !icon_path) {
		dlog_print(DLOG_ERROR, LOG_TAG, "Invalid parameter");
		return NULL;
	}

	item = (app_item_t *)calloc(1, sizeof(app_item_t));
	if (!item) {
		dlog_print(DLOG_ERROR, LOG_TAG, "Allocation failed");
		return NULL;
	}

	item->app_id = strdup(app_id);
	item->icon_path = strdup(icon_path);

	return item;
}
