/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __MAIN_H__
#define __MAIN_H__

#include <Elementary.h>
#include <Ecore.h>
#include <app.h>
#include <dlog.h>
#include <zlib.h>
#include <libgen.h>
#include <string.h>
#include <ioapi.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <errno.h>
#include <fcntl.h>
#include <unistd.h>
#include <utime.h>
#include <storage.h>
#include <efl_extension.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "zip.h"
#include "unzip.h"
#include <media_content.h>

#define KEY_END "XF86Stop"

#define CASESENSITIVITY (0)
#define WRITEBUFFERSIZE (16384)
#define MAXFILENAME (256)

typedef struct appdata {
    Evas_Object *DEBUG_BOX;
    Evas_Object *win;
    Evas_Object *navi;
    Evas_Object *lab_file;
    Evas_Object *lab_destination;
    Evas_Object *parent_list;
    Evas_Object *lab_zip, *lab_gz;
    Evas_Object *bt1, *bt2, *bt3, *bt4;

    char *destination_folder_path;
    char *media_folder_path;
} appdata_s;

typedef enum compression_type {
    ZIP,
    GZ
} compression_type_e;

Evas_Object *_new_button(appdata_s *ad, Evas_Object *display, char *name, void *cb);
void _convert_file(appdata_s *ad, char *ext);
char *check_if_file(void *data, const char *file);
int check_exist_file(const char *file);
int makedir(const char *newdir);
void change_file_date(const char *filename, uLong dosdate, tm_unz tmu_date);

#ifdef  LOG_TAG
#undef  LOG_TAG
#endif
#define LOG_TAG "$(appName)"

#if !defined(PACKAGE)
#define PACKAGE "$(packageName)"
#endif

#endif                           /* __MAIN_H__ */
