/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef MY_FILE_SELECTOR_H
#define MY_FILE_SELECTOR_H

#include "main.h"
#define PATHLEN 256

typedef void (*file_selector_selected_cb) (const char *file_path, void *data);
typedef struct file_selector_data_s {
    char dir_path[PATHLEN];
    Evas_Object *file_popup;
    Evas_Object *folder_path;
    file_selector_selected_cb selected_callback;
    void *extra_data;
    bool folder_selection;
    Evas_Object *file_list;
} file_selector_data_s;
file_selector_data_s file_selector_data;

void create_file_popup(Evas_Object *file_popup);
void show_file_popup(file_selector_selected_cb selected_callback, bool folder_selection,
                     void *data);
void hide_file_popup();
Eina_Bool file_selector_shown();
void fill_file_list(Evas_Object *file_list);

#endif                           // MY_FILE_SELECTOR_H
