/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef USR_CB_H
#define USR_CB_H

#include "main.h"

void show_popup(void *data, const char *title, const char *message);

void _choose_file_cb(void *data, Evas_Object *obj, void *event_info);

void _choose_destination_cb(void *data, Evas_Object *obj, void *event_info);

void _convert_cb(void *data, Evas_Object *obj, void *event_info);

void _block_clicked(void *data, Evas_Object *obj, void *event_info);

void _timeout(void *data, Evas_Object *obj, void *event_info);

void _fs_selected_file(const char *file_path, void *data);

void _fs_selected_dest(const char *file_path, void *data);

void _check_format_cb(void *data, Evas_Object *obj, void *event_info);

void _check_overwrite_cb(void *data, Evas_Object *obj, void *event_info);

void _check_append_cb(void *data, Evas_Object *obj, void *event_info);

#endif
