/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "user_callbacks.h"
#include "main.h"

#include <privilege_information.h>

#define privilege "http://tizen.org/privilege/application.launch"
/*
 * Create submenu here
 */

void _get_privilege_info_cb(void *data, Evas_Object *obj, void *event_info)
{
	PRINT_MSG("<b>Privilege:</b><br>%s<br>", privilege);
	PRINT_MSG("<b>Privilege details:</b><br>");
    // Get the privilege display name
    char *displayName = NULL;
    int retVal = privilege_info_get_display_name("2.4", privilege, &displayName);
    if (retVal != PRVINFO_ERROR_NONE) {
        dlog_print(DLOG_DEBUG, LOG_TAG, "[privilege_info_get_display_name] Failed.");
        PRINT_MSG("[privilege_info_get_display_name] Failed.<br>");
    } else {
        dlog_print(DLOG_DEBUG, LOG_TAG, "Display name: %s", displayName);
        PRINT_MSG("<b>Display name:</b><br>%s<br>", displayName);
    }

    // Get the privilege display name by package type
    retVal = privilege_info_get_display_name_by_pkgtype(
            "PRVINFO_PACKAGE_TYPE_WEB", "2.4", privilege, &displayName);
    if (retVal != PRVINFO_ERROR_NONE) {
        dlog_print(DLOG_DEBUG, LOG_TAG, "[privilege_info_get_display_name_by_pkgtype] Failed.");
        PRINT_MSG("[privilege_info_get_display_name_by_pkgtype] Failed.<br>");
    } else {
        dlog_print(DLOG_DEBUG, LOG_TAG, "Display name (by package type): %s", displayName);
        PRINT_MSG("<b>Display name (by package type):</b><br>%s<br>", displayName);
    }

    // Get the privilege description
    char *description = NULL;
    retVal = privilege_info_get_description("2.4", privilege, &description);
    if (retVal != PRVINFO_ERROR_NONE) {
        dlog_print(DLOG_DEBUG, LOG_TAG, "[privilege_info_get_description] Failed.");
        PRINT_MSG("[privilege_info_get_descriptione] Failed.<br>");
    } else {
        dlog_print(DLOG_DEBUG, LOG_TAG, "Description: %s", description);
        PRINT_MSG("<b>Description:</b><br>%s<br>", description);
    }

    // Get the privilege description by package type
    retVal = privilege_info_get_description_by_pkgtype("PRVINFO_PACKAGE_TYPE_WEB",
            "2.4", privilege, &description);
    if (retVal != PRVINFO_ERROR_NONE) {
        dlog_print(DLOG_DEBUG, LOG_TAG, "[privilege_info_get_description_by_pkgtype] Failed.");
        PRINT_MSG("[privilege_info_get_description_by_pkgtype] Failed.<br>");
    } else {
        dlog_print(DLOG_DEBUG, LOG_TAG, "Description (by package type): %s", description);
        PRINT_MSG("<b>Description (by package type):</b><br>%s<br>", description);
    }
}

void create_buttons_in_main_window(appdata_s *ad)
{
    Evas_Object *display = _create_new_cd_display(ad, "Privilege info", _pop_cb);
    _new_button(ad, display, "Start", _get_privilege_info_cb);
}
