/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "user_callbacks.h"
#include "main.h"

#define TAG "MY_APP"

void _dlog_cb(void *data, Evas_Object *obj, void *event_info)
{
    int integer = 21;
    char string[] = "dlog test";

    dlog_print(DLOG_DEBUG, TAG, "Debug message");
    PRINT_MSG("Sent to dlog: Debug message");

    dlog_print(DLOG_INFO, TAG, "Info message");
    PRINT_MSG("Sent to dlog: Info message");

    dlog_print(DLOG_WARN, TAG, "Warning message");
    PRINT_MSG("Sent to dlog: Warning message");

    dlog_print(DLOG_ERROR, TAG, "Error message");
    PRINT_MSG("Sent to dlog: Error message");

    dlog_print(DLOG_DEBUG, TAG, "%s, %d", string, integer);
    PRINT_MSG("Sent to dlog: %s, %d", string, integer);
}

void create_buttons_in_main_window(appdata_s *ad)
{
    Evas_Object *display = _create_new_cd_display(ad, "Dlog", _pop_cb);
    _new_button(ad, display, "Print Dlog messages", _dlog_cb);
}
