/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "user_callbacks.h"
#include "main.h"
#include <media_key.h>

void media_key_cb(media_key_e key, media_key_event_e status, void *user_data)
{
    switch (key) {
    case MEDIA_KEY_PLAY:
        dlog_print(DLOG_DEBUG, LOG_TAG, "Key : MEDIA_KEY_PLAY");
        PRINT_MSG("Key : MEDIA_KEY_PLAY");
        break;

    case MEDIA_KEY_STOP:
        dlog_print(DLOG_DEBUG, LOG_TAG, "Key : MEDIA_KEY_STOP");
        PRINT_MSG("Key : MEDIA_KEY_STOP");
        break;

    case MEDIA_KEY_PAUSE:
        dlog_print(DLOG_DEBUG, LOG_TAG, "Key : MEDIA_KEY_PAUSE");
        PRINT_MSG("Key : MEDIA_KEY_PAUSE");
        break;

    case MEDIA_KEY_PREVIOUS:
        dlog_print(DLOG_DEBUG, LOG_TAG, "Key : MEDIA_KEY_PREVIOUS");
        PRINT_MSG("Key : MEDIA_KEY_PREVIOUS");
        break;

    case MEDIA_KEY_NEXT:
        dlog_print(DLOG_DEBUG, LOG_TAG, "Key : MEDIA_KEY_NEXT");
        PRINT_MSG("Key : MEDIA_KEY_NEXT");
        break;

    case MEDIA_KEY_FASTFORWARD:
        dlog_print(DLOG_DEBUG, LOG_TAG, "Key : MEDIA_KEY_FASTFORWARD");
        PRINT_MSG("Key : MEDIA_KEY_FASTFORWARD");
        break;

    case MEDIA_KEY_REWIND:
        dlog_print(DLOG_DEBUG, LOG_TAG, "Key : MEDIA_KEY_REWIND");
        PRINT_MSG("Key : MEDIA_KEY_REWIND");
        break;

    case MEDIA_KEY_PLAYPAUSE:
        dlog_print(DLOG_DEBUG, LOG_TAG, "Key : MEDIA_KEY_PLAYPAUSE");
        PRINT_MSG("Key : MEDIA_KEY_PLAYPAUSE");
        break;

    case MEDIA_KEY_UNKNOWN:
        dlog_print(DLOG_DEBUG, LOG_TAG, "Key : MEDIA_KEY_UNKNOWN");
        PRINT_MSG("Key : MEDIA_KEY_UNKNOWN");
        break;

    default:
        dlog_print(DLOG_DEBUG, LOG_TAG, "Key : Unknown");
        PRINT_MSG("Key : Unknown");
    }

    switch (status) {
    case MEDIA_KEY_STATUS_PRESSED:
        dlog_print(DLOG_DEBUG, LOG_TAG, "Event : MEDIA_KEY_STATUS_PRESSED");
        PRINT_MSG("Event : MEDIA_KEY_STATUS_PRESSED");
        break;

    case MEDIA_KEY_STATUS_RELEASED:
        dlog_print(DLOG_DEBUG, LOG_TAG, "Event : MEDIA_KEY_STATUS_RELEASED");
        PRINT_MSG("Event : MEDIA_KEY_STATUS_RELEASED");
        break;

    case MEDIA_KEY_STATUS_UNKNOWN:
        dlog_print(DLOG_DEBUG, LOG_TAG, "Event : MEDIA_KEY_STATUS_UNKNOWN");
        PRINT_MSG("Event : MEDIA_KEY_STATUS_UNKNOWN");
        break;

    default:
        dlog_print(DLOG_DEBUG, LOG_TAG, "Event : Unknown");
        PRINT_MSG("Event : Unknown");
    }
}

void _reserve_key_cb(void *data, Evas_Object *obj, void *event_info)
{
    int ret = 0;

    ret = media_key_reserve(media_key_cb, NULL);
    if (ret == MEDIA_KEY_ERROR_NONE) {
        dlog_print(DLOG_DEBUG, LOG_TAG, "Reserve media key success");
        PRINT_MSG("Reserve successful, press any media key");
    } else {
        dlog_print(DLOG_ERROR, LOG_TAG, "Reserve media key failed");
        PRINT_MSG("media_key_reserve failed");
    }
}

void _release_key_cb(void *data, Evas_Object *obj, void *event_info)
{
    int ret = 0;

    ret = media_key_release();
    if (ret == MEDIA_KEY_ERROR_NONE) {
        dlog_print(DLOG_DEBUG, LOG_TAG, "Media key released");
        PRINT_MSG("Media key released");
    } else {
        dlog_print(DLOG_DEBUG, LOG_TAG, "media_key_release error: %d", ret);
        PRINT_MSG("media_key_release error: %d", ret);
    }
}

Eina_Bool media_key_pop_cb(void *data, Elm_Object_Item *item)
{
    int ret = 0;

    ret = media_key_release();
    if (ret == MEDIA_KEY_ERROR_NONE)
        dlog_print(DLOG_DEBUG, LOG_TAG, "Media key released");
    else
        dlog_print(DLOG_DEBUG, LOG_TAG, "media_key_release error: %d", ret);

    return _pop_cb(data, item);
}

void create_buttons_in_main_window(appdata_s *ad)
{
    Evas_Object *display = _create_new_cd_display(ad, "Media Key", media_key_pop_cb);
    _new_button(ad, display, "Reserve media key", _reserve_key_cb);
    _new_button(ad, display, "Release media key", _release_key_cb);
}
