/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "user_callbacks.h"
#include "main.h"

#include <runtime_info.h>

void _runtime_info_get_value_cb(void *data, Evas_Object *obj, void *event_info)
{
    bool value_bool;
    int ret;

    ret = runtime_info_get_value_bool(RUNTIME_INFO_KEY_BLUETOOTH_ENABLED, &value_bool);
    if (ret != RUNTIME_INFO_ERROR_NONE) {
        PRINT_MSG("runtime_info_get_value_bool error: %d", ret);
        dlog_print(DLOG_ERROR, LOG_TAG, "runtime_info_get_value_bool error: %d", ret);
        return;
    } else {
        dlog_print(DLOG_DEBUG, LOG_TAG, "Bluetooth: %s", value_bool ? "Enabled" : "Disabled");
        PRINT_MSG("Bluetooth: %s", value_bool ? "Enabled" : "Disabled");
    }
}

void _runtime_info_get_audiojack_cb(void *data, Evas_Object *obj, void *event_info)
{
    int value_int;
    int ret;

    ret = runtime_info_get_value_int(RUNTIME_INFO_KEY_AUDIO_JACK_STATUS, &value_int);
    if (ret != RUNTIME_INFO_ERROR_NONE) {
        PRINT_MSG("runtime_info_get_value_int error: %d", ret);
        dlog_print(DLOG_ERROR, LOG_TAG, "runtime_info_get_value_int error: %d", ret);
        return;
    } else {
        switch (value_int) {
        case RUNTIME_INFO_AUDIO_JACK_STATUS_UNCONNECTED:
            dlog_print(DLOG_DEBUG, LOG_TAG, "Audio jack status: not connected.");
            PRINT_MSG("Audio jack status: not connected.");
            break;

        case RUNTIME_INFO_AUDIO_JACK_STATUS_CONNECTED_3WIRE:
            dlog_print(DLOG_DEBUG, LOG_TAG, "Audio jack status: connected - 3 wire.");
            PRINT_MSG("Audio jack status: connected - 3 wire.");
            break;

        case RUNTIME_INFO_AUDIO_JACK_STATUS_CONNECTED_4WIRE:
            dlog_print(DLOG_DEBUG, LOG_TAG, "Audio jack status: connected - 4 wire.");
            PRINT_MSG("Audio jack status: connected - 4 wire.");
            break;

        default:
            dlog_print(DLOG_DEBUG, LOG_TAG, "Audio jack status: unknown.");
            PRINT_MSG("Audio jack status: unknown.");
            break;
        }
    }
}

void usb_connection_changed(runtime_info_key_e key, void *user_data)
{
    bool value;
    int ret;

    ret = runtime_info_get_value_bool(key, &value);
    if (ret != RUNTIME_INFO_ERROR_NONE) {
        PRINT_MSG("runtime_info_get_value_bool error: %d", ret);
        dlog_print(DLOG_ERROR, LOG_TAG, "runtime_info_get_value_bool error: %d", ret);
        return;
    }

    PRINT_MSG("USB status: %s", value ? "Connected" : "Disconnected");
    dlog_print(DLOG_ERROR, LOG_TAG, "USB status: %s", value ? "Connected" : "Disconnected");
}

void _runtime_info_set_callback_cb(void *data, Evas_Object *obj, void *event_info)
{
    int ret;

    ret = runtime_info_set_changed_cb(RUNTIME_INFO_KEY_USB_CONNECTED, usb_connection_changed, NULL);
    if (ret != RUNTIME_INFO_ERROR_NONE) {
        PRINT_MSG("runtime_info_set_changed_cb error: %d", ret);
        dlog_print(DLOG_ERROR, LOG_TAG, "runtime_info_set_changed_cb error: %d", ret);
    } else
        PRINT_MSG("USB status callback set");
}

void _runtime_info_remove_callback_cb(void *data, Evas_Object *obj, void *event_info)
{
    int ret;

    ret = runtime_info_unset_changed_cb(RUNTIME_INFO_KEY_USB_CONNECTED);
    if (ret != RUNTIME_INFO_ERROR_NONE) {
        PRINT_MSG("runtime_info_unset_changed_cb error: %d", ret);
        dlog_print(DLOG_ERROR, LOG_TAG, "runtime_info_unset_changed_cb error: %d", ret);
    } else
        PRINT_MSG("USB status callback unset");
}

void create_buttons_in_main_window(appdata_s *ad)
{
    Evas_Object *display = _create_new_cd_display(ad, "Runtime info", _pop_cb);
    _new_button(ad, display, "Get 'Bluetooth enabled' value", _runtime_info_get_value_cb);
    _new_button(ad, display, "Get audio jack status", _runtime_info_get_audiojack_cb);
    _new_button(ad, display, "Set USB status callback", _runtime_info_set_callback_cb);
    _new_button(ad, display, "Remove USB status callback", _runtime_info_remove_callback_cb);
}
