/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __vc_elm_H__
#define __vc_elm_H__

#include <app.h>
#include <system_settings.h>
#include <Elementary.h>
#include <efl_extension.h>
#include <dlog.h>
#include <voice_control_elm.h>

#define KEY_END "XF86Stop"
#define KEY_MORE "XF86Send"
#define ICON_DIR "/opt/usr/apps/org.tizen.vc-elm-test/res/icon"

#if !defined(PACKAGE)
#define PACKAGE "org.tizen.vc-elm-test"
#endif

#ifdef  LOG_TAG
#undef  LOG_TAG
#endif
#define LOG_TAG "vc-elm-test"

typedef struct appdata {
  Evas_Object *win;
  Evas_Object *conform;
  Evas_Object *nf;
  Evas_Object *genlist;
  Evas_Object *popup;
} appdata_s;

Evas_Object*
create_genlist(appdata_s *ad);

#endif /* __vc_elm_H__ */
