/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "vc-elm.h"

static Eina_Bool g_switch_state[10] =
	{0, };
static int g_radio_state = 0;
static double g_slider_state = 0;
static double g_slider2_state = 0;
static Evas_Object *radio_group = NULL;
static vc_elm_h voice_h[10] =
	{0, };
static Elm_Object_Item *genlist_item_list[10] =
	{0, };

static void item_activated_cb(void *data, Evas_Object *obj, void *event_info)
{
	Eina_Bool *check = data;
	*check = !(*check);
	elm_genlist_item_selected_set(event_info, EINA_FALSE);
	elm_genlist_item_update(event_info);
}

static void item_radio_activated_cb(void *data, Evas_Object *obj, void *event_info)
{
	g_radio_state = (int)data;
	elm_genlist_item_selected_set(event_info, EINA_FALSE);
	elm_genlist_item_update(event_info);
}

static void item_slider_activated_cb(void *data, Evas_Object *obj, void *event_info)
{
	elm_genlist_item_selected_set(event_info, EINA_FALSE);
	elm_genlist_item_update(event_info);
}

static void item_slider_moved_cb(void *data, Evas_Object *obj, void *event_info)
{
	double *slider = (double *)data;
	*slider = elm_slider_value_get(obj);
}

static char* genlist_text_get_cb(void *data, Evas_Object *obj, const char *part)
{
	int item_number = (int *)data;

	if (!strcmp("elm.text", part)) {
		if (item_number == 0) {
			return strdup("Airplane mode");
		} else if (item_number == 1) {
			return strdup("Check Box");
		} else {
			return strdup("Radio On");
		}
	}
	return NULL;
}

/* Function setting image for genlist items */
static Evas_Object*
genlist_content_get_cb(void *data, Evas_Object *obj, const char *part)
{
	int item_number = (int)data;

	if (!strcmp(part, "elm.swallow.icon.1")) {
		if (item_number == 0) {
			Evas_Object *checkbox = NULL;

			checkbox = elm_check_add(obj);
			elm_object_style_set(checkbox, "on&off");
			elm_check_state_set(checkbox, EINA_TRUE);
			elm_check_state_pointer_set(checkbox, (g_switch_state));
			evas_object_smart_callback_add(checkbox, "changed", item_activated_cb, (g_switch_state));
			evas_object_size_hint_align_set(checkbox, 0.7, EVAS_HINT_FILL);
			evas_object_size_hint_weight_set(checkbox, 1, 1);

			vc_elm_create_object(checkbox, &voice_h[item_number]);
			vc_elm_set_command(voice_h[item_number], "airplane");
			vc_elm_set_command_hint(voice_h[item_number], "airplane");
			return checkbox;
		} else if (item_number == 1) {
			Evas_Object *checkbox = NULL;

			checkbox = elm_check_add(obj);
			elm_check_state_set(checkbox, EINA_TRUE);
			elm_check_state_pointer_set(checkbox, (g_switch_state + item_number));
			evas_object_smart_callback_add(checkbox, "changed", item_activated_cb, (g_switch_state + item_number));
			evas_object_size_hint_align_set(checkbox, 0.7, EVAS_HINT_FILL);
			evas_object_size_hint_weight_set(checkbox, 1, 1);

			vc_elm_create_object(checkbox, &voice_h[item_number]);
			vc_elm_set_command(voice_h[item_number], "check");
			vc_elm_set_command_hint(voice_h[item_number], "check");
			return checkbox;
		} else {
			Evas_Object *radio = NULL;

			radio = elm_radio_add(obj);
			elm_radio_state_value_set(radio, 0);
			elm_radio_group_add(radio, radio_group);
			elm_radio_value_pointer_set(radio_group, &g_radio_state);

			evas_object_smart_callback_add(radio, "changed", item_radio_activated_cb, (void *)0);
			evas_object_size_hint_align_set(radio, 0.7, EVAS_HINT_FILL);
			evas_object_size_hint_weight_set(radio, 1, 1);

			vc_elm_create_object(radio, &voice_h[item_number]);
			vc_elm_set_command(voice_h[item_number], "on");
			vc_elm_set_command_hint(voice_h[item_number], "on");
			return radio;
		}
	}
	return NULL;
}

static void genlist_del_cb(void *data, Evas_Object *obj)
{
	int item_number = (int)data;
	vc_elm_destroy(voice_h[item_number]);
	if (7 == item_number)
		vc_elm_destroy(voice_h[item_number + 1]);
}

/* Prepare genlist example */
Evas_Object*
create_genlist(appdata_s *ad)
{
	Elm_Genlist_Item_Class *gic;
	Evas_Object *genlist;

	genlist = elm_genlist_add(ad->nf);
	evas_object_size_hint_weight_set(genlist, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	evas_object_size_hint_align_set(genlist, EVAS_HINT_FILL, EVAS_HINT_FILL);

	elm_genlist_homogeneous_set(genlist, EINA_TRUE);
	elm_genlist_mode_set(genlist, ELM_LIST_COMPRESS);

	gic = elm_genlist_item_class_new();
	gic->item_style = "type1";
	gic->func.text_get = genlist_text_get_cb;;
	gic->func.content_get = genlist_content_get_cb;
	gic->func.state_get = NULL;
	gic->func.del = genlist_del_cb;

	genlist_item_list[0] = elm_genlist_item_append(genlist, gic, (void *)0, NULL, ELM_GENLIST_ITEM_NONE, item_activated_cb, (g_switch_state));
	genlist_item_list[2] = elm_genlist_item_append(genlist, gic, (void *)1, NULL, ELM_GENLIST_ITEM_NONE, item_activated_cb, (g_switch_state + 1));
	genlist_item_list[4] = elm_genlist_item_append(genlist, gic, (void *)2, NULL, ELM_GENLIST_ITEM_NONE, item_radio_activated_cb, (void *)0);

	evas_object_show(genlist);

	elm_genlist_item_class_free(gic);
	return genlist;
}
