#include "main.h"

typedef struct appdata {
	Evas_Object *nf;
	Eext_Circle_Surface *circle_surface;
} appdata_s;

typedef struct item_data
{
	int index;
	Elm_Object_Item *item;
} item_data;

char *genlist_demo_names[] = {
	"Aiden", "Owen", "Caden", "Ezra", "Dylan",
	"Logan", "Finn",
	NULL
};

static void
win_delete_request_cb(void *data, Evas_Object *obj, void *event_info)
{
	ui_app_exit();
}

static char*
gl_text_get(void *data, Evas_Object *obj, const char *part)
{
	char buf[1024];
	item_data *id = data;
	int index = id->index;

	if (index == 0)
		snprintf(buf, 1023, "%s", "Email Inbox");
	else if (index == 1)
		snprintf(buf, 1023, "%s", "circle@tizen.com");
	else if (!strcmp(part, "elm.text"))
		snprintf(buf, 1023, "%s", genlist_demo_names[index - 2]);
	else if (!strcmp(part, "elm.text.1"))
		snprintf(buf, 1023, "%s", "Re: Long time no see");
	else
		snprintf(buf, 1023, "%s", "Hello~! how have you been?");

	return strdup(buf);
}

static void
gl_del(void *data, Evas_Object *obj)
{
	item_data *id = data;
	if (id) free(id);
}

static Evas_Object*
create_label(appdata_s *ad, Elm_Object_Item *it)
{
	Evas_Object *label;
	char buf[PATH_MAX];

	label = elm_label_add(ad->nf);

	//label creates for text view.
	snprintf(buf, sizeof(buf), " %s %s", elm_object_item_part_text_get(it, "elm.text.1"),
										elm_object_item_part_text_get(it, "elm.text.2"));
	elm_label_line_wrap_set(label, ELM_WRAP_MIXED);
	elm_object_text_set(label, buf);
	evas_object_show(label);

	return label;
}

static void
gl_selected_cb(void *data, Evas_Object *obj, void *event_info)
{
	Evas_Object *label;
	Elm_Object_Item *it = event_info;
	appdata_s *ad = data;
	elm_genlist_item_selected_set(it, EINA_FALSE);

	label = create_label(ad, it);
	//View changed to text detail view.
	elm_naviframe_item_push(ad->nf, elm_object_item_part_text_get(it, "elm.text"), NULL, NULL, label, NULL);

	return;
}

static Evas_Object *
create_genlist(appdata_s *ad)
{
	int i;
	Evas_Object *genlist, *circle_genlist;
	Elm_Object_Item *item;

	//Added 2 genlist item class for title, groupindex, items.
	Elm_Genlist_Item_Class *tic = elm_genlist_item_class_new();
	Elm_Genlist_Item_Class *gic = elm_genlist_item_class_new();
	Elm_Genlist_Item_Class *iic = elm_genlist_item_class_new();
	Elm_Genlist_Item_Class *pic = elm_genlist_item_class_new();

	tic->item_style = "title_with_groupindex";
	tic->func.text_get = gl_text_get;
	tic->func.content_get = NULL;
	tic->func.del = gl_del;

	gic->item_style = "groupindex";
	gic->func.text_get = gl_text_get;
	gic->func.content_get = NULL;
	gic->func.del = gl_del;

	iic->item_style = "3text";
	iic->func.text_get = gl_text_get;
	iic->func.content_get = NULL;
	iic->func.del = gl_del;

	pic->item_style = "padding";

	genlist = elm_genlist_add(ad->nf);
	//Eext genlist add to given genlist object. for draw circular scroll bar.
	circle_genlist = eext_circle_object_genlist_add(genlist, ad->circle_surface);

	//This genlist is not scrolled to X axis.
	eext_circle_object_genlist_scroller_policy_set(circle_genlist, ELM_SCROLLER_POLICY_OFF, ELM_SCROLLER_POLICY_AUTO);
	//Rotary event activated for genlist to get rotary event.
	eext_rotary_object_event_activated_set(circle_genlist, EINA_TRUE);

	for (i = 0; i < NUM_OF_ITEMS; i++)
	{
		item_data *id = calloc(sizeof(item_data), 1);
		id->index = i;

		if (i == 0) {
			item = elm_genlist_item_append(
											genlist,            // genlist object
											tic,                // item class
											id,                 // data
											NULL,
											ELM_GENLIST_ITEM_GROUP,
											NULL,
											NULL);
			//Title item in only for display.
			elm_genlist_item_select_mode_set(item, ELM_OBJECT_SELECT_MODE_DISPLAY_ONLY);
		}
		else if (i == 1) {
		    item = elm_genlist_item_append(
											genlist,            // genlist object
											gic,                // item class
											id,                 // data
											NULL,
											ELM_GENLIST_ITEM_GROUP,
											NULL,
											NULL);
			//groupindex item in only for display.
			elm_genlist_item_select_mode_set(item, ELM_OBJECT_SELECT_MODE_DISPLAY_ONLY);
		}
		else
		    item = elm_genlist_item_append(
											genlist,            // genlist object
											iic,                // item class
											id,                 // data
											NULL,
											ELM_GENLIST_ITEM_NONE,
											gl_selected_cb,
											ad);

		id->item = item;
	}
	// Padding Item Here
	elm_genlist_item_append(genlist, pic, NULL, NULL, ELM_GENLIST_ITEM_NONE, NULL, NULL);


	elm_genlist_item_class_free(tic);
	elm_genlist_item_class_free(gic);
	elm_genlist_item_class_free(iic);
	elm_genlist_item_class_free(pic);
	evas_object_show(genlist);

	return genlist;
}

static Eina_Bool
naviframe_pop_cb(void *data, Elm_Object_Item *it)
{
	ui_app_exit();
	return EINA_FALSE;
}

static void
create_main_view(appdata_s *ad)
{
	Elm_Object_Item *nf_it;
	Evas_Object *genlist;

	genlist = create_genlist(ad);

	nf_it = elm_naviframe_item_push(ad->nf, NULL, NULL, NULL, genlist, "empty");
	elm_naviframe_item_pop_cb_set(nf_it, naviframe_pop_cb, NULL);
}

static void
create_base_gui(appdata_s *ad)
{
	/* Window */
	Evas_Object *win, *conform;
	win = elm_win_util_standard_add(PACKAGE, PACKAGE);
	elm_win_autodel_set(win, EINA_TRUE);

	evas_object_smart_callback_add(win, "delete,request", win_delete_request_cb, NULL);

	/* Conformant */
	conform = elm_conformant_add(win);

	evas_object_size_hint_weight_set(conform, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	elm_win_resize_object_add(win, conform);
	evas_object_show(conform);

	/* Naviframe */
	ad->nf = elm_naviframe_add(conform);
	elm_object_content_set(conform, ad->nf);
	ad->circle_surface = eext_circle_surface_naviframe_add(ad->nf);

	create_main_view(ad);

	eext_object_event_callback_add(ad->nf, EEXT_CALLBACK_BACK, eext_naviframe_back_cb, NULL);

	/* Show window after base gui is set up */
	evas_object_show(win);
}

static bool
app_create(void *data)
{
	/* Hook to take necessary actions before main event loop starts
		Initialize UI resources and application's data
		If this function returns true, the main loop of application starts
		If this function returns false, the application is terminated */
	appdata_s *ad = data;

	create_base_gui(ad);

	return true;
}

static void
app_control(app_control_h app_control, void *data)
{
	/* Handle the launch request. */
}

static void
app_pause(void *data)
{
	/* Take necessary actions when application becomes invisible. */
}

static void
app_resume(void *data)
{
	/* Take necessary actions when application becomes visible. */
}

static void
app_terminate(void *data)
{
	/* Release all resources. */
}

static void
ui_app_lang_changed(app_event_info_h event_info, void *user_data)
{
	/*APP_EVENT_LANGUAGE_CHANGED*/
	char *locale = NULL;
	system_settings_get_value_string(SYSTEM_SETTINGS_KEY_LOCALE_LANGUAGE, &locale);
	elm_language_set(locale);
	free(locale);
	return;
}

static void
ui_app_orient_changed(app_event_info_h event_info, void *user_data)
{
	/*APP_EVENT_DEVICE_ORIENTATION_CHANGED*/
	return;
}

static void
ui_app_region_changed(app_event_info_h event_info, void *user_data)
{
	/*APP_EVENT_REGION_FORMAT_CHANGED*/
}

static void
ui_app_low_battery(app_event_info_h event_info, void *user_data)
{
	/*APP_EVENT_LOW_BATTERY*/
}

static void
ui_app_low_memory(app_event_info_h event_info, void *user_data)
{
	/*APP_EVENT_LOW_MEMORY*/
}

int
main(int argc, char *argv[])
{
	appdata_s ad = {0,};
	int ret = 0;

	ui_app_lifecycle_callback_s event_callback = {0,};
	app_event_handler_h handlers[5] = {NULL, };

	event_callback.create = app_create;
	event_callback.terminate = app_terminate;
	event_callback.pause = app_pause;
	event_callback.resume = app_resume;
	event_callback.app_control = app_control;

	ui_app_add_event_handler(&handlers[APP_EVENT_LOW_BATTERY], APP_EVENT_LOW_BATTERY, ui_app_low_battery, &ad);
	ui_app_add_event_handler(&handlers[APP_EVENT_LOW_MEMORY], APP_EVENT_LOW_MEMORY, ui_app_low_memory, &ad);
	ui_app_add_event_handler(&handlers[APP_EVENT_DEVICE_ORIENTATION_CHANGED], APP_EVENT_DEVICE_ORIENTATION_CHANGED, ui_app_orient_changed, &ad);
	ui_app_add_event_handler(&handlers[APP_EVENT_LANGUAGE_CHANGED], APP_EVENT_LANGUAGE_CHANGED, ui_app_lang_changed, &ad);
	ui_app_add_event_handler(&handlers[APP_EVENT_REGION_FORMAT_CHANGED], APP_EVENT_REGION_FORMAT_CHANGED, ui_app_region_changed, &ad);
	ui_app_remove_event_handler(handlers[APP_EVENT_LOW_MEMORY]);

	ret = ui_app_main(argc, argv, &event_callback, &ad);
	if (ret != APP_ERROR_NONE) {
		dlog_print(DLOG_ERROR, LOG_TAG, "app_main() is failed. err = %d", ret);
	}

	return ret;
}
