/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "main.h"

typedef struct appdata {
	Evas_Object *win;
	Evas_Object *grid;
	Evas_Object *entry;
	Evas_Object *popup;
	Ecore_Timer *timer;
} appdata_s;

static void
win_delete_request_cb(void *data, Evas_Object *obj, void *event_info)
{
	ui_app_exit();
}

static Eina_Bool
_timeout_cb(void *data)
{
	appdata_s *ad = (appdata_s *)data;

	evas_object_del(ad->popup);
	if (ad->timer) {
		ecore_timer_del(ad->timer);
		ad->timer = NULL;
	}

	return ECORE_CALLBACK_CANCEL;
}

static void
win_back_cb(void *data, Evas_Object *obj, void *event_info)
{
	appdata_s *ad = data;
	/* Let window go to hide state. */
	elm_win_lower(ad->win);
}

static void
clicked_0_cb(void *data, Evas_Object *obj EINA_UNUSED, void *event_info EINA_UNUSED)
{
	Evas_Object *entry = data;
	elm_entry_entry_append(entry, "0");
}

static void
clicked_1_cb(void *data, Evas_Object *obj EINA_UNUSED, void *event_info EINA_UNUSED)
{
	Evas_Object *entry = data;
	elm_entry_entry_append(entry, "1");
}

static void
clicked_2_cb(void *data, Evas_Object *obj EINA_UNUSED, void *event_info EINA_UNUSED)
{
	Evas_Object *entry = data;
	elm_entry_entry_append(entry, "2");
}

static void
clicked_3_cb(void *data, Evas_Object *obj EINA_UNUSED, void *event_info EINA_UNUSED)
{
	Evas_Object *entry = data;
	elm_entry_entry_append(entry, "3");
}

static void
clicked_4_cb(void *data, Evas_Object *obj EINA_UNUSED, void *event_info EINA_UNUSED)
{
	Evas_Object *entry = data;
	elm_entry_entry_append(entry, "4");
}

static void
clicked_5_cb(void *data, Evas_Object *obj EINA_UNUSED, void *event_info EINA_UNUSED)
{
	Evas_Object *entry = data;
	elm_entry_entry_append(entry, "5");
}

static void
clicked_6_cb(void *data, Evas_Object *obj EINA_UNUSED, void *event_info EINA_UNUSED)
{
	Evas_Object *entry = data;
	elm_entry_entry_append(entry, "6");
}

static void
clicked_7_cb(void *data, Evas_Object *obj EINA_UNUSED, void *event_info EINA_UNUSED)
{
	Evas_Object *entry = data;
	elm_entry_entry_append(entry, "7");
}

static void
clicked_8_cb(void *data, Evas_Object *obj EINA_UNUSED, void *event_info EINA_UNUSED)
{
	Evas_Object *entry = data;
	elm_entry_entry_append(entry, "8");
}

static void
clicked_9_cb(void *data, Evas_Object *obj EINA_UNUSED, void *event_info EINA_UNUSED)
{
	Evas_Object *entry = data;
	elm_entry_entry_append(entry, "9");
}

static void
clicked_call_cb(void *data, Evas_Object *obj EINA_UNUSED, void *event_info EINA_UNUSED)
{
	appdata_s *ad = (appdata_s *)data;

	ad->popup = elm_popup_add(ad->grid);
	elm_popup_align_set(ad->popup, ELM_NOTIFY_ALIGN_FILL, 1.0);
	evas_object_size_hint_weight_set(ad->popup, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	elm_object_text_set(ad->popup, "It is just sample application.");

	if (!ad->timer)
		ad->timer = ecore_timer_add(3, (Ecore_Task_Cb)_timeout_cb, ad);

	evas_object_show(ad->popup);
}

static void
clicked_cancel_cb(void *data, Evas_Object *obj EINA_UNUSED, void *event_info EINA_UNUSED)
{
	Evas_Object *entry = data;
	const char *tmp;
	char *ch = NULL;
	int len;

	tmp = elm_entry_entry_get(entry);
	if (!tmp) return;
	ch = strdup(tmp);

	len = strlen(ch);
	if (len > 1) {
		ch[len-1] = '\0';
		elm_entry_entry_set(entry, ch);
	}
	else
		elm_entry_entry_set(entry, "");
}

static Evas_Object *
create_panel(Evas_Object *parent, appdata_s *ad)
{
	Evas_Object *table, *button;

	elm_theme_extension_add(NULL, ELM_DEMO_EDJ);

	table = elm_table_add(parent);
	elm_table_padding_set(table, 1, 1);

	button = elm_button_add(table);
	elm_object_style_set(button, "dialer");
	evas_object_size_hint_weight_set(button, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	evas_object_size_hint_align_set(button, EVAS_HINT_FILL, EVAS_HINT_FILL);
	elm_object_text_set(button, "1");
	evas_object_smart_callback_add(button, "clicked", clicked_1_cb, ad->entry);
	evas_object_show(button);
	elm_table_pack(table, button, 0, 0, 1, 1);

	button = elm_button_add(table);
	elm_object_style_set(button, "dialer");
	evas_object_size_hint_weight_set(button, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	evas_object_size_hint_align_set(button, EVAS_HINT_FILL, EVAS_HINT_FILL);
	elm_object_text_set(button, "2");
	evas_object_smart_callback_add(button, "clicked", clicked_2_cb, ad->entry);
	evas_object_show(button);
	elm_table_pack(table, button, 1, 0, 1, 1);

	button = elm_button_add(table);
	elm_object_style_set(button, "dialer");
	evas_object_size_hint_weight_set(button, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	evas_object_size_hint_align_set(button, EVAS_HINT_FILL, EVAS_HINT_FILL);
	elm_object_text_set(button, "3");
	evas_object_smart_callback_add(button, "clicked", clicked_3_cb, ad->entry);
	evas_object_show(button);
	elm_table_pack(table, button, 2, 0, 1, 1);

	button = elm_button_add(table);
	elm_object_style_set(button, "dialer");
	evas_object_size_hint_weight_set(button, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	evas_object_size_hint_align_set(button, EVAS_HINT_FILL, EVAS_HINT_FILL);
	elm_object_text_set(button, "4");
	evas_object_smart_callback_add(button, "clicked", clicked_4_cb, ad->entry);
	evas_object_show(button);
	elm_table_pack(table, button, 0, 1, 1, 1);

	button = elm_button_add(table);
	elm_object_style_set(button, "dialer");
	evas_object_size_hint_weight_set(button, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	evas_object_size_hint_align_set(button, EVAS_HINT_FILL, EVAS_HINT_FILL);
	elm_object_text_set(button, "5");
	evas_object_smart_callback_add(button, "clicked", clicked_5_cb, ad->entry);
	evas_object_show(button);
	elm_table_pack(table, button, 1, 1, 1, 1);

	button = elm_button_add(table);
	elm_object_style_set(button, "dialer");
	evas_object_size_hint_weight_set(button, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	evas_object_size_hint_align_set(button, EVAS_HINT_FILL, EVAS_HINT_FILL);
	elm_object_text_set(button, "6");
	evas_object_smart_callback_add(button, "clicked", clicked_6_cb, ad->entry);
	evas_object_show(button);
	elm_table_pack(table, button, 2, 1, 1, 1);

	button = elm_button_add(table);
	elm_object_style_set(button, "dialer");
	evas_object_size_hint_weight_set(button, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	evas_object_size_hint_align_set(button, EVAS_HINT_FILL, EVAS_HINT_FILL);
	elm_object_text_set(button, "7");
	evas_object_smart_callback_add(button, "clicked", clicked_7_cb, ad->entry);
	evas_object_show(button);
	elm_table_pack(table, button, 0, 2, 1, 1);

	button = elm_button_add(table);
	elm_object_style_set(button, "dialer");
	evas_object_size_hint_weight_set(button, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	evas_object_size_hint_align_set(button, EVAS_HINT_FILL, EVAS_HINT_FILL);
	elm_object_text_set(button, "8");
	evas_object_smart_callback_add(button, "clicked", clicked_8_cb, ad->entry);
	evas_object_show(button);
	elm_table_pack(table, button, 1, 2, 1, 1);

	button = elm_button_add(table);
	elm_object_style_set(button, "dialer");
	evas_object_size_hint_weight_set(button, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	evas_object_size_hint_align_set(button, EVAS_HINT_FILL, EVAS_HINT_FILL);
	elm_object_text_set(button, "9");
	evas_object_smart_callback_add(button, "clicked", clicked_9_cb, ad->entry);
	evas_object_show(button);
	elm_table_pack(table, button, 2, 2, 1, 1);

	button = elm_button_add(table);
	elm_object_style_set(button, "dialer");
	evas_object_size_hint_weight_set(button, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	evas_object_size_hint_align_set(button, EVAS_HINT_FILL, EVAS_HINT_FILL);
	elm_object_text_set(button, "call");
	evas_object_smart_callback_add(button, "clicked", clicked_call_cb, ad);
	evas_object_show(button);
	elm_table_pack(table, button, 0, 3, 1, 1);

	button = elm_button_add(table);
	elm_object_style_set(button, "dialer");
	evas_object_size_hint_weight_set(button, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	evas_object_size_hint_align_set(button, EVAS_HINT_FILL, EVAS_HINT_FILL);
	elm_object_text_set(button, "0");
	evas_object_smart_callback_add(button, "clicked", clicked_0_cb, ad->entry);
	evas_object_show(button);
	elm_table_pack(table, button, 1, 3, 1, 1);

	button = elm_button_add(table);
	elm_object_style_set(button, "dialer");
	evas_object_size_hint_weight_set(button, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	evas_object_size_hint_align_set(button, EVAS_HINT_FILL, EVAS_HINT_FILL);
	elm_object_text_set(button, "cancel");
	evas_object_smart_callback_add(button, "clicked", clicked_cancel_cb, ad->entry);
	evas_object_show(button);
	elm_table_pack(table, button, 2, 3, 1, 1);

	evas_object_show(table);

	return table;
}

static Evas_Object *
create_entry(Evas_Object *parent)
{
	Evas_Object *entry;

	entry = elm_entry_add(parent);
	elm_entry_editable_set(entry, EINA_FALSE);
	elm_entry_single_line_set(entry, EINA_TRUE);
	elm_entry_text_style_user_push(entry, "DEFAULT='font_size=50 align=center'");
	evas_object_show(entry);

	return entry;
}

static void
create_base_gui(appdata_s *ad)
{
	Evas_Object *panel;
	Evas_Object *conform;

	/* Window */
	ad->win = elm_win_util_standard_add(PACKAGE, PACKAGE);
	elm_win_autodel_set(ad->win, EINA_TRUE);

	evas_object_smart_callback_add(ad->win, "delete,request", win_delete_request_cb, NULL);
	eext_object_event_callback_add(ad->win, EEXT_CALLBACK_BACK, win_back_cb, ad);

	/* Conformant */
	conform = elm_conformant_add(ad->win);
	evas_object_size_hint_weight_set(conform, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	elm_win_resize_object_add(ad->win, conform);
	evas_object_show(conform);

	/* Grid */
	ad->grid = elm_grid_add(conform);
	elm_object_content_set(conform, ad->grid);

	/* Entry */
	ad->entry = create_entry(ad->grid);
	elm_grid_pack(ad->grid, ad->entry, 5, 5, 90, 20);

	/* Panel */
	panel = create_panel(ad->grid, ad);
	elm_grid_pack(ad->grid, panel, 0, 30, 100, 70);

	/* Show window after base gui is set up */
	evas_object_show(ad->win);
}

static bool
app_create(void *data)
{
	/* Hook to take necessary actions before main event loop starts
		Initialize UI resources and application's data
		If this function returns true, the main loop of application starts
		If this function returns false, the application is terminated */
	appdata_s *ad = data;

	create_base_gui(ad);

	return true;
}

static void
app_control(app_control_h app_control, void *data)
{
	/* Handle the launch request. */
}

static void
app_pause(void *data)
{
	/* Take necessary actions when application becomes invisible. */
}

static void
app_resume(void *data)
{
	/* Take necessary actions when application becomes visible. */
}

static void
app_terminate(void *data)
{
	/* Release all resources. */
}

static void
ui_app_lang_changed(app_event_info_h event_info, void *user_data)
{
	/*APP_EVENT_LANGUAGE_CHANGED*/
	char *locale = NULL;
	system_settings_get_value_string(SYSTEM_SETTINGS_KEY_LOCALE_LANGUAGE, &locale);
	elm_language_set(locale);
	free(locale);
	return;
}

static void
ui_app_orient_changed(app_event_info_h event_info, void *user_data)
{
	/*APP_EVENT_DEVICE_ORIENTATION_CHANGED*/
	return;
}

static void
ui_app_region_changed(app_event_info_h event_info, void *user_data)
{
	/*APP_EVENT_REGION_FORMAT_CHANGED*/
}

static void
ui_app_low_battery(app_event_info_h event_info, void *user_data)
{
	/*APP_EVENT_LOW_BATTERY*/
}

static void
ui_app_low_memory(app_event_info_h event_info, void *user_data)
{
	/*APP_EVENT_LOW_MEMORY*/
}

int
main(int argc, char *argv[])
{
	appdata_s ad = {0,};
	int ret = 0;

	ui_app_lifecycle_callback_s event_callback = {0,};
	app_event_handler_h handlers[5] = {NULL, };

	event_callback.create = app_create;
	event_callback.terminate = app_terminate;
	event_callback.pause = app_pause;
	event_callback.resume = app_resume;
	event_callback.app_control = app_control;

	ui_app_add_event_handler(&handlers[APP_EVENT_LOW_BATTERY], APP_EVENT_LOW_BATTERY, ui_app_low_battery, &ad);
	ui_app_add_event_handler(&handlers[APP_EVENT_LOW_MEMORY], APP_EVENT_LOW_MEMORY, ui_app_low_memory, &ad);
	ui_app_add_event_handler(&handlers[APP_EVENT_DEVICE_ORIENTATION_CHANGED], APP_EVENT_DEVICE_ORIENTATION_CHANGED, ui_app_orient_changed, &ad);
	ui_app_add_event_handler(&handlers[APP_EVENT_LANGUAGE_CHANGED], APP_EVENT_LANGUAGE_CHANGED, ui_app_lang_changed, &ad);
	ui_app_add_event_handler(&handlers[APP_EVENT_REGION_FORMAT_CHANGED], APP_EVENT_REGION_FORMAT_CHANGED, ui_app_region_changed, &ad);
	ui_app_remove_event_handler(handlers[APP_EVENT_LOW_MEMORY]);

	ret = ui_app_main(argc, argv, &event_callback, &ad);
	if (ret != APP_ERROR_NONE) {
		dlog_print(DLOG_ERROR, LOG_TAG, "app_main() is failed. err = %d", ret);
	}

	return ret;
}
