/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#if !defined(_DATA_H)
#define _DATA_H

typedef struct _noti_data {
	char *icon_path;
	char *title;
	char *body_text;
	char *date;
} noti_data_s;

/*
 * Initialize the data component
 */
void data_initialize(void);

/*
 * Finalize the data component
 */
void data_finalize(void);

void data_get_resource_path(const char *file_in, char *file_path_out, int file_path_max);

Eina_List *data_get_noti_list(void);
noti_data_s *data_get_noti_item_by_index(int index);
int data_get_notification_count(void);
char *data_get_noti_icon_path(int index);
char *data_get_noti_title(int index);
char *data_get_noti_body_text(int index);
char *data_get_noti_date(int index);

#endif
