/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#if !defined(_VIEW_H)
#define _VIEW_H

#define EDJ_FILE "edje/main.edj"
#define GRP_MAIN "main"

typedef enum {
	VIEW_TYPE_COVER = 0,
	VIEW_TYPE_COLLAPSED = 1,
	VIEW_TYPE_EXPANDED = 2,
	VIEW_TYPE_MAX,
} view_type_e;

Evas_Object *view_get_window(void);
Evas_Object *view_get_conformant(void);
Evas_Object *view_get_naviframe(void);
Evas_Object *view_get_scroller(Evas_Object *parent);
Evas_Object *view_get_box(Evas_Object *parent);

/*
 * Create a view
 */
Eina_Bool view_create(void);
Evas_Object *view_create_win(const char *pkg_name);
Evas_Object *view_create_conformant_without_indicator(Evas_Object *win);
Evas_Object *view_create_layout(Evas_Object *parent, const char *file_path, const char *group_name, Eext_Event_Cb cb_function, void *user_data);
Evas_Object *view_create_layout_for_conformant(Evas_Object *parent, const char *file_path, const char *group_name, Eext_Event_Cb cb_function, void *user_data);
Evas_Object *view_create_layout_by_theme(Evas_Object *parent, const char *class_name, const char *group_name, const char *style);
void view_create_circle_scroller(Evas_Object *scroller);
Evas_Object *view_create_scroller_padding(Evas_Object *parent, int height);
Evas_Object *view_create_scroller(Evas_Object *parent);
Evas_Object *view_create_box(Evas_Object *parent);
void view_append_item_to_box(Evas_Object *box, Evas_Object *item);
void view_destroy(void);
void view_set_image(Evas_Object *parent, const char *part_name, const char *image_path);
void view_set_text(Evas_Object *parent, const char *part_name, const char *text);
Evas_Object *view_create_naviframe(Evas_Object *parent);
Elm_Object_Item* view_push_item_to_naviframe(Evas_Object *nf, Evas_Object *item, Elm_Naviframe_Item_Pop_Cb pop_cb, void *user_data);

Evas_Object *view_create_no_contents_layout(Evas_Object *parent, const char *title, const char *text, const char *icon_path);
void view_notification_viewer_create(void);
Evas_Object *view_notification_create_expanded_label(Evas_Object *parent);
void view_notification_set_expanded_label_text(Evas_Object *label, const char *text);
void view_notification_set_more_button(Evas_Object *parent, const char *part_name, Evas_Object *layout_more_btn, int count);

#endif
