/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <app.h>
#include <Elementary.h>
#include <dlog.h>

#include "$(appName).h"
#include "data.h"


static char *menu_its[] = {
	/*** 1line styles ***/
	"Display",
	"Vibration",
	"Device",
	"Call",
	"Connections",
	"Screen lock",
	"Input",
	"Power saving",
	"Gear info",
	/* do not delete below */
	NULL
};

static char *display_its[] = {
	/*** 1line styles ***/
	"Watch faces",
	"Watch always on",
	"Notification indicator",
	"Brightness",
	"Screen timeout",
	"Font",
	/* do not delete below */
	NULL
};

/*
 * display items's values.
 * states of check boxes is controlled by these values.
 */
static int display_its_value[] = {
		-1,	/* Watch faces */
		0,	/* Watch always on */
		0,	/* Notification indicator */
		-1,	/* Brightness */
		-1,	/* Screen timeout */
		-1	/* Font */
};

/*
 * @brief: Initialize data that is used in this application.
 */
void data_initialize(void)
{
	/*
	 * If you need to initialize managing data,
	 * please use this function.
	 */
}

/*
 * @brief: Destroy data that is used in this application.
 */
void data_finalize(void)
{
	/*
	 * If you need to finalize managing data,
	 * please use this function.
	 */
}
/*
 * @brief: Get text
 * @param[part]: Name string of one of the existing text parts in the EDJ group
 */
char *data_get_text(const char *part)
{
	/*
	 * You can use this function to retrieve data.
	 */
	return NULL;
}

/*
 * @brief: Function will be operated when items are shown on the screen
 * @param[data]: Data passed from 'elm_genlist_item_append' as third parameter
 * @param[obj]: Genlist
 * @param[part]: Name string of one of the existing text parts in the EDJ group implementing the item's theme
 */
char *data_get_menu_title_text(void *data, Evas_Object *obj, const char *part)
{
	char buf[BUF_LEN];

	snprintf(buf, sizeof(buf), "%s", "Settings");
	return strdup(buf);
}

/*
 * @brief: Function will be operated when items are shown on the screen
 * @param[data]: Data passed from 'elm_genlist_item_append' as third parameter
 * @param[obj]: Genlist
 * @param[part]: Name string of one of the existing text parts in the EDJ group implementing the item's theme
 */
char *data_get_display_title_text(void *data, Evas_Object *obj, const char *part)
{
	char buf[BUF_LEN];

	snprintf(buf, sizeof(buf), "%s", "Display");
	return strdup(buf);
}

/*
 * @brief: Function will be operated when items are shown on the screen
 * @param[data]: Data passed from 'elm_genlist_item_append' as third parameter
 * @param[obj]: Genlist
 * @param[part]: Name string of one of the existing text parts in the EDJ group implementing the item's theme
 */
char *data_get_menu_text(void *data, Evas_Object *obj, const char *part)
{
	int index = (int)data;
	char buf[BUF_LEN];

	if (!strcmp(part, "elm.text")) {
		snprintf(buf, sizeof(buf), "%s", menu_its[index]);
		return strdup(buf);
	}
	return NULL;
}

/*
 * @brief: Function will be operated when items are shown on the screen
 * @param[data]: Data passed from 'elm_genlist_item_append' as third parameter
 * @param[obj]: Genlist
 * @param[part]: Name string of one of the existing text parts in the EDJ group implementing the item's theme
 */
char *data_get_display_text(void *data, Evas_Object *obj, const char *part)
{
	char buf[BUF_LEN];
	int index = (int)data;

	if (!strcmp(part, "elm.text")) {
		snprintf(buf, sizeof(buf), "%s", display_its[index]);
		return strdup(buf);
	} else if (!strcmp(part, "elm.text.1")) {
		snprintf(buf, sizeof(buf), "%s", "30 seconds");
		return strdup(buf);
	}

	return NULL;
}

/*
 * @brief: Get display item's value that can shows state of check box
 * @param[index]: Index of display item's value
 * @param[value]: The point to which save value of display item
 */
void data_get_display_int_value(int index, int *value)
{
	*value = display_its_value[index];
}

/*
 * @brief: Set display item's value that can shows state of check box
 * @param[index]: Index of display item's value
 * @param[value]: Value of display item
 */
void data_set_display_int_value(int index, int value)
{
	display_its_value[index] = value;
}

/*
 * @brief: Get image name according as the number of index.
 * @param[index]: Index of genlist
 */
char *data_get_icon_name(int index)
{
	char buf[BUF_LEN];

		switch (index) {
		case 0:
			snprintf(buf, sizeof(buf), "%s", "images/settings_list_display.png");
			break;
		case 1:
			snprintf(buf, sizeof(buf), "%s", "images/settings_list_vibration.png");
			break;
		case 2:
			snprintf(buf, sizeof(buf), "%s", "images/settings_list_device.png");
			break;
		case 3:
			snprintf(buf, sizeof(buf), "%s", "images/settings_list_call.png");
			break;
		case 4:
			snprintf(buf, sizeof(buf), "%s", "images/settings_list_connections.png");
			break;
		case 5:
			snprintf(buf, sizeof(buf), "%s", "images/settings_list_security.png");
			break;
		case 6:
			snprintf(buf, sizeof(buf), "%s", "images/settings_list_input.png");
			break;
		case 7:
			snprintf(buf, sizeof(buf), "%s", "images/settings_list_power_saving.png");

			break;
		case 8:
			snprintf(buf, sizeof(buf), "%s", "images/settings_list_gear_info.png");
			break;
		default:
			dlog_print(DLOG_ERROR, LOG_TAG, "wrong approach");
			snprintf(buf, sizeof(buf), "%s", "");
			break;
		}

		return strdup(buf);
}

/*
 * @brief: Get path of resource.
 * @param[file_in]: File name
 * @param[file_path_out]: The point to which save full path of the resource
 * @param[file_path_max]: Size of file name include path
 */
void data_get_resource_path(const char *file_in, char *file_path_out, int file_path_max)
{
	char *res_path = app_get_resource_path();
	if (res_path) {
		snprintf(file_path_out, file_path_max, "%s%s", res_path, file_in);
		free(res_path);
	}
}

/* End of file */
