/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#if !defined(_VIEW_H)
#define _VIEW_H

#define ITEM_LAYOUT_WIDTH 360
#define ITEM_LAYOUT_HEIGHT 360
#define ICON_WIDTH 216 + 25
#define ICON_HEIGHT 360
#define PADDING_START "padding_start"

Evas_Object *view_get_win(void);
Evas_Object *view_get_box(void);
Evas_Object *view_get_layout(void);
void view_create(void);
Evas_Object *view_create_win(const char *pkg_name);
Evas_Object *view_create_conformant_without_indicator(Evas_Object *win);
Evas_Object *view_create_layout(Evas_Object *parent, const char *file_path, const char *group_name, Eext_Event_Cb cb_function, void *user_data);
Evas_Object *view_create_layout_for_part(Evas_Object *parent, char *file_path, char *group_name, char *part_name);
void view_destroy(void);
void view_set_image(Evas_Object *parent, const char *part_name, const char *image_path);
void view_set_text(Evas_Object *parent, const char *part_name, const char *text);
void view_set_button(Evas_Object *parent, const char *part_name, const char *style, const char *image_path, const char *text,
			Evas_Object_Event_Cb down_cb, Evas_Object_Event_Cb up_cb, Evas_Smart_Cb clicked_cb, void *user_data);
void view_set_customized_event_callback(Evas_Object *item, char *signal, char *source, Edje_Signal_Cb signal_cb, void *user_data);
void view_task_manager_create(char *file_path, char *group_name, char *scroller_part);
Evas_Object *view_create_horizontal_scroller(Evas_Object *parent, char *part_name, Evas_Smart_Cb scrolled_cb, void *user_data);
Evas_Object *view_create_horizontal_box(Evas_Object *parent, void *user_data);
void view_create_circular_index(Evas_Object *parent, char *part_name);
void view_add_circular_index(int idx, int item_count);
void view_sync_index_with_item(int idx);
void view_sync_index_with_page_on_scroll(void);
void view_update_index(void);
void view_set_bottom_button_disabled(Evas_Object *parent, Eina_Bool is_disabled);
Evas_Object *view_create_1text_1image_delbutton_item(Evas_Object *parent, char *file_pat, char *group_name);
void view_set_item_to_box(Evas_Object *box, Evas_Object *item);

#endif
