/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <app_common.h>
#include <Elementary.h>

#include "data.h"
#include "$(appName).h"

#define ITEM_COUNT 4

typedef struct {
	char *name;
	char *image;
} item_info;

static item_info recent_item[ITEM_COUNT] = {
	{ "alarm", "image/weather.png" },
	{ "music", "image/world_clock.png" },
	{ "contact", "image/music.png" },
	{ NULL, NULL },
};

void data_initialize(void)
{
	/*
	 * If you need to initialize managing data,
	 * please use this function.
	 */
}

void data_finalize(void)
{
	/*
	 * If you need to finalize managing data,
	 * please use this function.
	 */
}

/*
 * @brief: Get path of resource
 * @param[file_in]: File name
 * @param[file_path_out]: The point to which save full path of the resource
 * @param[file_path_max]: Size of file name include path
 */
void data_get_resource_path(const char *file_in, char *file_path_out, int file_path_max)
{
	char *res_path = app_get_resource_path();
	if (res_path) {
		snprintf(file_path_out, file_path_max, "%s%s", res_path, file_in);
		free(res_path);
	}
}

/* @brief: Get screenshot of item
 * @param[idx]: Index of image file will be used
 * @param[image]: Output buffer for application name
 * @param[image_len]: Size of output buffer
 */
int data_get_screenshot(int idx, char *image, int image_len)
{
	if (idx < 0 || idx > data_get_screenshot_count()) {
		return 0;
	}

	if (recent_item[idx].image == NULL) {
		return 0;
	}

	/*
	 * Find the PREDEFINED screen-shot image filename using idx,
	 */
	data_get_resource_path(recent_item[idx].image, image, image_len);
	return 1;
}

/*
 * @brief: Get the application name using given index from predefined data array
 * @param[idx]: Index of the screenshot data
 * @param[appname]: Output buffer for application name
 * @param[appname_len]: Size of output buffer
 */
int data_get_appname(int idx, char *appname, int appname_len)
{
	if (idx < 0 || idx > data_get_screenshot_count()) {
		return 0;
	}

	if (recent_item[idx].name == NULL) {
		return 0;
	}

	strncpy(appname, recent_item[idx].name, appname_len - 1);
	return 1;
}

/*
 * @brief: Get the number of items
 */
int data_get_screenshot_count(void)
{
	/* Counting the number of screen-shot items */
	return sizeof(recent_item) / sizeof(*recent_item);
}

