/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#if !defined(_DATA_H)
#define _DATA_H

#include <stdbool.h>

typedef struct app_info {
	char *id;
	char *name;
	char *version;
	char *icon_path;
} app_info_t;

typedef struct path_type {
	const char *name;
	char *path;
} path_type_t;

void data_initialize(void);
void data_finalize(void);
bool data_get_path(int path_index, path_type_t **path);
void data_get_app_info(app_info_t **app_info);
bool data_get_files_count(const char *path, int *files_count);

#endif
