/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#if !defined(_VIEW_H)
#define _VIEW_H

#include <Elementary.h>
#include <stdbool.h>
#include "data.h"

typedef void (*app_info_query_cb)(app_info_t **app_info);
typedef bool (*path_query_cb)(path_type_t **path);
typedef int (*path_files_query_cb)(const char *path);

Eina_Bool view_create(void *user_data);
Evas_Object *view_create_win(const char *pkg_name);
Evas_Object *view_create_conformant(Evas_Object *parent);
Evas_Object *view_create_layout(Evas_Object *parent, const char *edj_file_name, const char *edj_group);
Evas_Object *view_create_set_layout(Evas_Object *parent, const char *edj_file_name, const char *edj_group, const char *target_part_name);
Evas_Object *view_create_image(Evas_Object *parent, const char *part_name);
Evas_Object *view_create_genlist(Evas_Object *parent, const char *target_part_name);
Elm_Genlist_Item_Class *view_create_genlist_item_class(Elm_Genlist_Item_Content_Get_Cb on_content_get_cb);
void view_set_callbacks(app_info_query_cb app_info_query_func, path_query_cb path_query_func, path_files_query_cb path_files_query_func);
void view_update_battery_status(app_event_low_battery_status_e status);
void view_update_memory_status(app_event_low_memory_status_e status);
void view_update_language(const char *language);
void view_update_region_format(const char *region);
void view_update_orientation(const char *orientation, int angle);
int view_get_rotation(void);
void view_destroy(void);

#endif
