/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#if !defined(_VIEW_DEFINES_H_)
#define _VIEW_DEFINES_H_

#define EDJ_MAIN "edje/main.edj"
#define GRP_MAIN "main"
#define PART_MAIN_TOOLBAR_TAB_APPS "main_toolbar_tab_apps"
#define PART_MAIN_TOOLBAR_TAB_PATHS "main_toolbar_tab_paths"
#define PART_MAIN_TOOLBAR_TABS "main_toolbar_tab_*"
#define PART_MAIN_CONTENT "main_content"

#define SIGNAL_TOOLBAR_TAB_APPS_SELECT "signal,toolbar,tab,apps,select"
#define SIGNAL_TOOLBAR_TAB_SELECTED "signal,toolbar,tab,selected"

#define EDJ_APP "edje/layout_app.edj"
#define GRP_APP "app"
#define PART_APP_ICON "app_icon"
#define PART_APP_NAME "app_name"
#define PART_APP_ID "app_id"
#define PART_APP_VER "app_ver"
#define PART_APP_MEMORY "app_memory"
#define PART_APP_BATTERY "app_battery"
#define PART_APP_LANG "app_lang"
#define PART_APP_REGION "app_region"
#define PART_APP_ORIENT "app_orientation"
#define PART_APP_ANGLE "app_angle"

#define SIGNAL_BATTERY_NORMAL "signal,battery,normal"
#define SIGNAL_BATTERY_CRITICAL "signal,battery,critical"
#define SIGNAL_BATTERY_OFF "signal,battery,off"
#define SIGNAL_MEMORY_NORMAL "signal,memory,normal"
#define SIGNAL_MEMORY_SOFT_WARNING "signal,memory,soft_warning"
#define SIGNAL_MEMORY_HARD_WARNING "signal,memory,hard_warning"

#define EDJ_PATHS "edje/layout_paths.edj"
#define GRP_PATHS "paths"
#define PART_PATHS_CONTENT "paths_content"
#define PART_PATHS_TOP_ICON "paths_top_icon"

#define GRP_PATHS_LIST_ITEM "paths_list_item"
#define PART_PATHS_LIST_ITEM_DESC "paths_list_item_desc"
#define PART_PATHS_LIST_ITEM_PATH "paths_list_item_path"

#define EDJ_POPUP "edje/layout_popup.edj"
#define GRP_POPUP "popup"
#define PART_POPUP_TITLE "popup_title"
#define PART_POPUP_PATH "popup_path"
#define PART_POPUP_COUNTER "popup_counter"
#define PART_POPUP_BUTTON "popup_button"

#define SIGNAL_POPUP_BUTTON_PRESSED "signal,popup,button,pressed"

#endif
