/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#if !defined(_DATA_H)
#define _DATA_H

#include <Eina.h>

#define APP_INDEX_EMAIL -1

void data_finalize(void);
bool data_add_application(const char *appid, const char *operation);
bool data_set_application(const char *appid, const char *operation);
bool data_set_application_data(int index, const char *key, const char *value);
bool data_search_application(const char *operation, app_control_app_matched_cb func_cb);
bool data_launch_application(int index, app_control_reply_cb func_cb);
bool data_terminate_application(int index);
char *data_get_icon_path(const char *appid);

#endif
