/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#if !defined(_VIEW_H)
#define _VIEW_H

#include <Elementary.h>

typedef void (*search_cb)(const char *operation);
typedef void (*execute_cb)(int app_index, const char *operation);
typedef void (*terminate_cb)(int app_index);
typedef void (*send_cb)(const char *address_to, const char *message);

Eina_Bool view_create(void *user_data);
Evas_Object *view_create_win(const char *pkg_name);
Evas_Object *view_create_conformant(Evas_Object *win);
Evas_Object *view_create_layout(Evas_Object *parent, const char *edj_file_name, const char *edj_group_name, const char *edj_part_name);
Evas_Object *view_create_scroller(Evas_Object *parent, const char *part_name);
Evas_Object *view_create_gengrid(Evas_Object *parent, const char *part_name);
Evas_Object *view_create_image(Evas_Object *parent, const char *file_path);
Evas_Object *view_create_entry(Evas_Object *parent, const char *edj_part_name);
void view_set_callbacks(search_cb search_func_cb, execute_cb execute_func_cb, terminate_cb terminate_func_cb, send_cb send_func_cb);
Eina_Bool view_add_application(const char *caption, const char *icon_path);
void view_destroy(void);

#endif
