/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#if !defined(_VIEW_DEFINES_H)
#define _VIEW_DEFINES_H

#define EDJ_MAIN "edje/main.edj"
#define GRP_MAIN "main"
#define PART_MAIN_OPERATIONS "main_operations"
#define PART_MAIN_APPS_LIST "main_apps_list"
#define PART_MAIN_COMPOSE "main_compose"

#define EDJ_OPERATIONS "edje/operations.edj"
#define GRP_OPERATIONS "operations"
#define PART_OPERATION_OPER_1 "operation_oper_1"
#define PART_OPERATION_OPER_2 "operation_oper_2"
#define PART_OPERATION_OPER_3 "operation_oper_3"
#define PART_OPERATION_OPERATIONS "operation_oper_*"
#define PART_OPERATION_OPER_1_CAPTION PART_OPERATION_OPER_1"_caption"
#define PART_OPERATION_OPER_2_CAPTION PART_OPERATION_OPER_2"_caption"
#define PART_OPERATION_OPER_3_CAPTION PART_OPERATION_OPER_3"_caption"

#define SIGNAL_OPERATION_RADIO_SELECTED "signal,operation,radio,selected"

#define EDJ_APPS_LIST "edje/apps_list.edj"
#define GRP_APPS_LIST "apps_list"
#define PART_APPS_LIST_APPS_LIST "apps_list_apps_list"
#define PART_APPS_LIST_BUTTON_EXECUTE "apps_list_button_execute"
#define PART_APPS_LIST_BUTTON_KILL "apps_list_button_kill"

#define SIGNAL_BUTTON_EXECUTE_CLICKED "signal,button,clicked,execute"
#define SIGNAL_BUTTON_KILL_CLICKED "signal,button,clicked,kill"

#define EDJ_APPS_ITEM_THEME "edje/apps_item_theme.edj"
#define SIGNAL_APPS_ITEM_ENABLE "signal,apps-item,enable"
#define SIGNAL_APPS_ITEM_DISABLE "signal,apps-item,disable"

#define EDJ_COMPOSE "edje/compose.edj"
#define GRP_COMPOSE "compose"
#define PART_COMPOSE_MESSAGE "compose_message"
#define PART_COMPOSE_ENTRY_MAIL_TO "compose_entry_mail_to"
#define PART_COMPOSE_BUTTON_SEND "compose_button_send"

#define SIGNAL_MAIL_TO_HINT_SHOW "signal,mail-to,show"
#define SIGNAL_MAIL_TO_HINT_HIDE "signal,mail-to,hide"
#define SIGNAL_BUTTON_SEND_CLICKED "signal,button,clicked,send"

#endif
