/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#if !defined(_DATA_H)
#define _DATA_H

#include <stdbool.h>
#include <bundle.h>

#define BUNDLE_HEADER_KEY "HEADER"
#define BUNDLE_HEADER_DATA_KEY "HEADER_DATA"

#define MESSAGE_PORT_RCV_NAME PACKAGE"_msg_port_local_rcv"

typedef enum {
	TITLE,
	DATA,
	HEADER,
	HEADER_DATA,
} bundle_message_type_e;

typedef void (*message_data_new_cb)(int index);

void data_initialize(message_data_new_cb new_data_cb);
void data_finalize(void);
bool data_create_bundle(void);
void data_destroy_bundle(void);
bool data_add_header(void);
bool data_add_byte(const char *key, int value);
bool data_add_string(const char *key, const char *value);
bool data_key_exists(int index, const char *key);
int data_is_byte(int index, const char *key);
int          data_get_count(int index);
int          data_get_byte(int index, const char *key);
char        *data_get_string(int index, const char *key);
const char **data_get_string_array(int index, const char *key, int *len);
char        *data_get_type_text(int index, const char *key);
Eina_List   *data_get_keys(int index);
void data_delete_key(int index, const char *key);
void data_clear_bundle(void);
bool data_send_message(void);
#endif
