/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#if !defined(_VIEW_LIST_H_)
#define _VIEW_LIST_H_

Evas_Object *view_list_create(Evas_Object *parent);
Elm_Genlist_Item_Class *view_list_add_itc(Elm_Gen_Item_Content_Get_Cb content_get_cb, Elm_Gen_Item_Del_Cb content_del_cb);
void view_list_add_tree_callbacks(Evas_Object *list, Elm_Gen_Item_Class *itc_parent, Elm_Gen_Item_Class *itc_child, Evas_Smart_Cb expand_callback, Evas_Smart_Cb contract_callback);
Elm_Object_Item *view_list_add_item(Evas_Object *list, Elm_Genlist_Item_Class *itc,
		Elm_Genlist_Item_Type item_type, Elm_Object_Item *parent_item,
		void *data, bool add_first,
		Elm_Object_Select_Mode mode,
		Evas_Smart_Cb func, const void *func_data);
void view_list_del_item(Evas_Object *list, Elm_Object_Item *item);
void view_list_del_item_cb(void *data, Evas_Object *obj);
Elm_Object_Item *view_list_find_item_by_text(Evas_Object *list, char *text);
void view_list_update(Evas_Object *list);
void view_list_item_update(Elm_Object_Item *item);


#endif
