/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#if !defined(_VIEW_SINK_H_)
#define _VIEW_SINK_H_

#include "data.h"

bool view_sink_create(Evas_Object *parent);
Evas_Object *view_sink_get(void);
void view_sink_received_byte_cb(bundle_message_type_e msg_type, const char *key, int value);
void view_sink_received_string_cb(bundle_message_type_e msg_type, const char *key, char *value);
void view_sink_received_array_cb(bundle_message_type_e msg_type, const char *key, char **value, int len);
void view_sink_new_message_cb(int index);

#endif
