/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#if !defined(_VIEW_DEFINES_H)
#define _VIEW_DEFINES_H

#define STATE_DEFAULT "default"
#define STATE_PRESSED "pressed"
#define STATE_INACTIVE "inactive"

#define EDJ_MAIN_FILE_NAME "edje/main.edj"
#define GROUP_MAIN "main"

#define EDJ_SOURCE_FILE_NAME "edje/data_source.edj"
#define GROUP_SOURCE "source"
#define GROUP_SOURCE_ITEM "item"
#define GROUP_SOURCE_HEADER "header"
#define GROUP_SOURCE_HEADER_DATA "header_data"

#define EDJ_SINK_FILE_NAME "edje/data_sink.edj"
#define GROUP_SINK "sink"
#define GROUP_TITLE "sink,list,title"
#define GROUP_ITEM "sink,list,item"
#define GROUP_HEADER "sink,list,header"
#define GROUP_HEADER_DATA "sink,list,header_data"

#define SIGNAL_SOURCE_ADD "signal,source,add"
#define SIGNAL_SOURCE_SEND "signal,source,send"
#define SIGNAL_SOURCE_BYTE_SELECTED "signal,source,byte,selected"
#define SIGNAL_SOURCE_STRING_SELECTED "signal,source,string,selected"
#define SIGNAL_SOURCE_INCLUDE_CHECKED "signal,source,include,checked"
#define SIGNAL_SOURCE_INCLUDE_UNCHECKED "signal,source,include,unchecked"
#define SIGNAL_SWITCH_SINK_VIEW "signal,source,view,sink"
#define SIGNAL_SWITCH_SOURCE_VIEW "signal,source,view,source"
#define SIGNAL_HEADER_OFF "signal,source,header_off"
#define SIGNAL_ARROW_STATE_CHANGE "signal,arrow,state_change"
#define SIGNAL_BUBBLES_HIDE "signal,bubbles,hide"
#define SIGNAL_ADD_ON "signal,source,add,on"
#define SIGNAL_ADD_OFF "signal,source,add,off"
#define SIGNAL_SEND_ON "signal,source,send,on"
#define SIGNAL_SEND_OFF "signal,source,send,off"
#define SIGNAL_SET_BYTE "signal,source,set,byte"
#define SIGNAL_SET_STRING "signal,source,set,string"

#define PART_VIEW "part,view"
#define PART_SOURCE_KEY "part,source,key"
#define PART_SOURCE_VALUE "part,source,value"
#define PART_ITEM_KEY_VAL "part,item,key_val"
#define PART_ITEM_TYPE "part,item,type"
#define PART_ITEM_TYPE "part,item,type"
#define PART_ITEM "part,item"
#define PART_LIST "part,list"
#define PART_ARROW "part,arrow"
#define PART_BUBBLES "part,bubbles"

#define IMAGE_ARROW_DOWN "../res/images/button3.png"
#define IMAGE_ARROW_UP "../res/images/button4.png"

#endif
