/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#if !defined(_DATA_H)
#define _DATA_H

typedef struct rule_data {
	int id;
	Eina_Bool enabled;
	char* name;
	char* description;
	char* msg;
	int result;
} rule_data_s;

typedef enum {
	RULE_FIRST = 0,
	RULE_BATTERY = RULE_FIRST,
	RULE_CALL = 1,
	RULE_DRIVING,
	RULE_HOME,
	RULE_LAST
} rule_e;

rule_data_s rule_info[RULE_LAST];

/*
 * Initialize the data component.
 */
void data_initialize(void);

/*
 * Finalize the data component.
 */
void data_finalize(void);

/*
 * Create and register contextual rules
 */
void add_rules(void);

/*
 * Unregister contextual rules
 */
void remove_rules(void);

/*
 * Activate the rule designated by rule id
 */
int enable_rule(int rule_id);

/*
 * Deactivate the rule designated by rule id
 */
int disable_rule(int rule_id);

#endif
