/*
 * Samsung API
 * Copyright (c) 2009-2015 Samsung Electronics Co., Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __main_H__
#define __main_H__

#include <app.h>
#include <Elementary.h>
#include <system_settings.h>
#include <efl_extension.h>
#include <dlog.h>
#include <Ecore.h>
#include <eom.h>

#define MAX_LENGTH_PATH 1024

typedef struct viewdata{
	Evas_Object *box_external;
	Evas_Object *bg;
	Evas_Object *text1;
	Evas_Object *text2;
	Evas_Object *text3;
} viewdata_s;

typedef struct appdata{
	Evas_Object *win;
	Evas_Object *external_win;
	Evas_Object *layout;
	Evas_Object *conform;
	Evas_Object *nf;
	Evas_Object *btn_mirror;
	Evas_Object *btn_presentation;
	Eina_Bool start;
	Eina_Bool support_external_display;
	Eina_Bool connected;
	Eina_Bool attribute_set;
	eom_output_mode_e mode;
	int output_id;

	viewdata_s *vd;
} appdata_s;

static inline const char *get_resource_path(const char * file_path);

#if !defined(PACKAGE)
#define PACKAGE "$(packageName)"
#endif

#define EDJPATH "edje"
#define LAYOUTEDJ get_resource_path(EDJPATH"/main_view.edj")
#define IMAGE_DIR "/opt/usr/apps/org.example.eom/res/images"


static inline const char *get_resource_path(const char *file_path)
{
    static char absolute_path[MAX_LENGTH_PATH] = {'\0'};

    static char *res_path_buff = NULL;
    if(res_path_buff == NULL)
    {
        res_path_buff = app_get_resource_path();
    }

    snprintf(absolute_path, MAX_LENGTH_PATH, "%s%s", res_path_buff, file_path);

    return absolute_path;
}

#endif /* __main_H__ */
