/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#if !defined(_VIEW_H)
#define _VIEW_H

#include <Evas.h>

typedef void (*event_do_publish_cb)(const char *event_name);
typedef bool (*event_get_system_info_cb)(int index, void **ev_info);
typedef bool (*event_set_custom_info_cb)(const char *event_name, void **ev_info);

Eina_Bool view_create(void *user_data);
Evas_Object *view_create_win(const char *pkg_name);
Evas_Object *view_create_conformant(Evas_Object *parent);
Evas_Object *view_create_set_layout(Evas_Object *parent, const char *edj_file_name, const char *edj_group, const char *target_part_name);
Evas_Object *view_create_layout(Evas_Object *parent, const char *edj_file_name, const char *edj_group);
Evas_Object *view_create_genlist(Evas_Object *parent, const char *target_part_name);
Evas_Object *view_create_entry(Evas_Object *parent, const char *target_part_name);
Evas_Object *view_create_scroller(Evas_Object *parent, const char *target_part_name);
Evas_Object *view_create_popup(Evas_Object *parent, const char *edj_file_name, const char *edj_group);
void view_destroy(void);
Elm_Genlist_Item_Class *view_create_genlist_item_class(Elm_Genlist_Item_Content_Get_Cb on_content_get_cb, Elm_Genlist_Item_Del_Cb on_del_cb);
void view_set_callbacks(event_do_publish_cb do_publish_func, event_get_system_info_cb get_system_info_func, event_set_custom_info_cb set_custom_info_func);
void view_update_system_events(void);
void view_update_custom_events(void);
void view_display_custom_event(const char *event_name, const char *event_status);

#endif
