/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#if !defined(_VIEW_DEFINES_H)
#define _VIEW_DEFINES_H

#define ITEM_WIDTH 720
#define ITEM_HEIGHT 227

#define EDJ_MAIN "edje/main.edj"
#define GRP_MAIN "main"
#define PART_MAIN_TOOLBAR "main_toolbar"
#define PART_MAIN_TOOLBAR_TABS "main_toolbar_tab_*"
#define PART_MAIN_TOOLBAR_TAB_SYS_EV "main_toolbar_tab_system_events"
#define PART_MAIN_TOOLBAR_TAB_CSTM_EV "main_toolbar_tab_custom_events"
#define PART_MAIN_CONTENT "main_content"

#define SIGNAL_TOOLBAR_TAB_SELECTED "signal,toolbar,tab,selected"
#define SIGNAL_TOOLBAR_TAB_SYS_EV_SELECT "signal,toolbar,tab,sys,select"

#define EDJ_SYS_EV "edje/system_events.edj"
#define GRP_SYS_EV "system_events"
#define PART_SYS_EV_CONTENT "system_events_content"

#define PART_TOP_ICON_SPACER "top_icon_spacer"
#define PART_TOP_ICON_BG "top_icon_background"
#define PART_TOP_ICON_BG_RECT "top_icon_background_rect"
#define PART_TOP_ICON_ARROW "top_icon_arrow"
#define PART_TOP_ICON_TEXT "top_icon_text"

#define SIGNAL_TOP_ICON_NORMAL "signal,top_icon,normal"
#define SIGNAL_TOP_ICON_ACTIVE "signal,top_icon,active"
#define SIGNAL_TOP_ICON_CLICKED "signal,top_icon,clicked"
#define SIGNAL_TOP_ICON_HIDDEN "signal,top_icon,hidden"
#define SIGNAL_TOP_ICON_ENTER "signal,top_icon"

#define GRP_SYS_EV_ITEM "system_events_item"
#define PART_SYS_EV_ITEM_FAV_ICON "system_events_item_favorite_icon"
#define PART_EV_ITEM_BG "part_event_item_background"
#define PART_EV_ITEM_TITLE "system_events_item_title"
#define PART_EV_ITEM_STATUS "system_events_item_status"

#define SIGNAL_ITEM "signal,item,*"
#define SIGNAL_ITEM_BG_LIGHT "signal,item,background,light"
#define SIGNAL_ITEM_BG_DARK "signal,item,background,dark"
#define SIGNAL_ITEM_BG_CLICKED "signal,item,background,clicked"
#define SIGNAL_ITEM_FAVORITE_ADDED "signal,item,favorite,added"
#define SIGNAL_ITEM_FAVORITE_REMOVED "signal,item,favorite,removed"
#define SIGNAL_ITEM_STATUS_TEXT "signal,status,text"
#define SIGNAL_ITEM_STATUS_ICON "signal,status,icon,*"
#define SIGNAL_ITEM_STATUS_ICON_LOW "signal,status,icon,low"
#define SIGNAL_ITEM_STATUS_ICON_HIGH "signal,status,icon,high"
#define SIGNAL_ITEM_STATUS_ICON_ "signal,status,icon,full"

#define EDJ_CSTM_EV "edje/custom_events.edj"
#define GRP_CSTM_EV "custom_events"
#define PART_CSTM_EV_TEXT_ENTRY "custom_events_text_entry"
#define PART_CSTM_EV_CONTENT "custom_event_content"
#define PART_CSTM_EV_TEXT_ENTRY_HINT "custom_events_text_entry_hint"
#define PART_CSTM_EV_ADD_EVENT_BTN "custom_events_add_button"

#define STYLE_CSTM_EV_TEXT_STYLE "DEFAULT='font=BreezeSans font_style=Normal font_weight=light font_width=normal color=#000000ff font_size=30 wrap=none align=center valign=center'"
#define TEXT_CSTM_EV_TEXT_ENTRY_HINT_TEXT "tap to add event name"

#define SIGNAL_TEXT_ENTRY_HINT_SHOW "signal,text_entry,show"
#define SIGNAL_TEXT_ENTRY_HINT_HIDE "signal,text_entry,hide"
#define SIGNAL_ADD_EVENT_BTN_CLICKED "signal,add_event,clicked"

#define GRP_CSTM_EV_ITEM "custom_event_item"
#define PART_CSTM_EV_ITEM_TRASH_BTN "custom_event_item_trash_button"

#define SIGNAL_TRASH_BTN_CLICKED "signal,trash_button,clicked"

#define GRP_CSTM_EV_POPUP "custom_event_popup"
#define PART_CSTM_EV_POPUP_BTN "custom_event_popup_button_*"
#define PART_CSTM_EV_POPUP_BTN_YES "custom_event_popup_button_yes"
#define PART_CSTM_EV_POPUP_BTN_NO "custom_event_popup_button_no"

#define SIGNAL_POPUP "signal,popup_button,*"
#define SIGNAL_POPUP_YES "signal,popup_button,yes"
#define SIGNAL_POPUP_NO "signal,popup_button,no"

#define GRP_CSTM_EV_PUBLISHED_POPUP "custom_event_published_popup"
#define PART_CSTM_EV_PUBLISHED_POPUP_MESSAGE "custom_event_published_popup_message"
#define PART_CSTM_EV_PUBLISHED_POPUP_BTN_OK "custom_event_popup_button_ok"

#define SIGNAL_PUBLISHED_POPUP_OK "signal,popup_button,ok"

#endif
