/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#if !defined(_VIEW_H)
#define _VIEW_H

#include <Elementary.h>
#include <stdbool.h>

typedef enum { LAYOUT_PREV, LAYOUT_NEXT } change_kbd_layout_dir_type;
typedef void (*autosave_toggle_cb)(bool state);
typedef void (*get_bind_file_path_cb)(const char **path, bool *autosave_state);

Eina_Bool view_create(void);
void view_set_callbacks(autosave_toggle_cb autosave_func, get_bind_file_path_cb bind_file_func);
Evas_Object *view_create_win(const char *pkg_name);
Evas_Object *view_create_layout(Evas_Object *parent, const char *edj_file_name, const char *edj_group, const char *target_part_name);
Evas_Object *view_create_button(Evas_Object *parent, const char *target_part_name, Evas_Smart_Cb on_click_cb, void *data);
Evas_Object *view_create_checkbox(Evas_Object *parent, const char *target_part_name, Evas_Smart_Cb on_change_cb);
void view_destroy(void);

#endif
