/*
 * Copyright (c) 2014 - 2015 Samsung Electronics Co., Ltd. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

#ifndef OAUTH_PROVIDER_CONFIGS_H_
#define OAUTH_PROVIDER_CONFIGS_H_

/*Twitter Service Provider related keys and urls*/
#define TWITTER_NAME "twitter"
#define TWITTER_CONS_KEY "dummy_consumer_key" /*Developer has to obtain the consumer key from twitter developer site*/
#define TWITTER_CONS_SEC "dummy_consumer_secret" /*Developer has to obtain the consumer secret from twitter developer site*/
#define TWITTER_REQ_TOK_URL "https://api.twitter.com/oauth/request_token"
#define TWITTER_AUTH_URL "https://api.twitter.com/oauth/authenticate"
#define TWITTER_ACC_TOK_URL "https://api.twitter.com/oauth/access_token"

/*Tumblr Service Provider related keys and urls*/
#define TUMBLR_NAME "tumblr"
#define TUMBLR_CONS_KEY "dummy_consumer_key" /*Developer has to obtain the consumer key from tumblr developer site*/
#define TUMBLR_CONS_SEC "dummy_consumer_secret" /*Developer has to obtain the consumer secret from tumblr developer site*/
#define TUMBLR_REQ_TOK_URL "http://www.tumblr.com/oauth/request_token"
#define TUMBLR_AUTH_URL "http://www.tumblr.com/oauth/authorize"
#define TUMBLR_ACC_TOK_URL "http://www.tumblr.com/oauth/access_token"

/*All apps are registered with this redirection url*/
#define OAUTH_REDIRECT_URL "dummy_redirect_url" /*Developer has to provide the redirect url*/

#endif /* OAUTH_PROVIDER_CONFIGS_H_ */
