/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#if !defined(_NOTIFICATION_COMMON_H)
#define _NOTIFICATION_COMMON_H

#include <notification.h>
#include <linux/limits.h>
#include <stdlib.h>

#define TEXT_SHORT_LEN 256
#define TEXT_MAX_LEN 1024

typedef struct _notification_data notification_data;
typedef void (*notification_cb)(notification_data *);
typedef bool (*badge_cb)(unsigned int *count, bool step);
typedef void (*launch_cb)(notification_h notification, const char *argument, const char *pkgname,
							const char *uri_text, const char *mime_text, const char *operation,
							const char **array_result, const char **array_key);

struct _notification_data {
	char name[TEXT_SHORT_LEN];
	notification_h notification;
	int press_count;
	double progress_value;
	notification_cb callback;
	char result_text[TEXT_MAX_LEN];
};

/**
 * @brief Get shared resources folder absolute path
 * @return Absolute path to shared resources folder
 */
static inline const char *get_shared_res_path(void)
{
	static char shared_res_folder_path[PATH_MAX] = { '\0' };
	if (shared_res_folder_path[0] == '\0') {
		char *resource_path_buf = app_get_shared_resource_path();
		strncpy(shared_res_folder_path, resource_path_buf, PATH_MAX-1);
		free(resource_path_buf);
	}
	return shared_res_folder_path;
}

#endif
