/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#if !defined(_DATA_H)
#define _DATA_H

typedef enum {PREF_INTEGER = 0, PREF_DOUBLE, PREF_BOOL, PREF_STRING, PREF_MAX} pref_value_type_t;

typedef struct _key_value {
	char *key;
	void *value;
	pref_value_type_t value_type;
} key_value_t;

typedef void (*preference_cb)(key_value_t *key_value);

void data_initialize(void);
void data_finalize(void);
void data_set_callback(preference_cb get_func);
bool data_update_preference(const char *key, const char *value, pref_value_type_t type);
bool data_remove_preferences(void);
bool data_remove_preference(const char *key);

#endif
