/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#if !defined(_VIEW_H)
#define _VIEW_H

#include <Elementary.h>
#include <Eina.h>
#include "data.h"

typedef void (*preference_update_cb)(const char *key, const char *value, pref_value_type_t type);
typedef bool (*preference_remove_all_cb)(void);
typedef bool (*preference_remove_cb)(const char *key);

Eina_Bool view_create(void);
void view_set_callbacks(preference_update_cb update_func, preference_remove_all_cb remove_all_func, preference_remove_cb remove_func);
Evas_Object *view_create_win(const char *pkg_name);
Evas_Object *view_create_conformant(Evas_Object *parent);
Evas_Object *view_create_layout(Evas_Object *parent, const char *edj_file_name, const char *edj_group, const char *target_part_name);
Evas_Object *view_create_entry(Evas_Object *parent, const char *target_part_name);
Evas_Object *view_create_button(Evas_Object *parent, const char *target_part_name, const char *caption, Evas_Smart_Cb on_click_cb);
Evas_Object *view_create_genlist(Evas_Object *parent, const char *target_part_name);
bool view_update_item(key_value_t *key_value);
void view_destroy(void);

#endif
