/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#if !defined(_VIEW_DEFINES_H)
#define _VIEW_DEFINES_H

#define TEXT_LABEL_COLOR_R 225
#define TEXT_LABEL_COLOR_G 225
#define TEXT_LABEL_COLOR_B 225
#define TEXT_LABEL_COLOR_A 255

#define ENTRY_BG_COLOR_R 225
#define ENTRY_BG_COLOR_G 225
#define ENTRY_BG_COLOR_B 225
#define ENTRY_BG_COLOR_A 255

#define EDJ_FILE_NAME_MAIN "edje/main.edj"
#define GROUP_MAIN "main"
#define PART_MAIN_BACKGROUND "background"
#define PART_MAIN_MAIN_PANEL "main_panel"
#define PART_MAIN_PREF_EDIT_PANEL "main_panel_pref_edit_panel"
#define PART_MAIN_PREF_LIST_PANEL "main_panel_pref_list_panel"
#define PART_MAIN_PREF_LIST_PANEL_BACKGROUND "main_panel_pref_list_panel_background"
#define PART_MAIN_PREF_BUTTONS_PANEL "main_panel_pref_buttons_panel"

#define MAIN_BACKGROUND_MARGIN_H 0.02
#define MAIN_BACKGROUND_MARGIN_V 0.01
#define MAIN_PREF_BUTTONS_PANEL_TOP 0.0
#define MAIN_PREF_BUTTONS_PANEL_HEIGHT 0.1
#define MAIN_PREF_EDIT_PANEL_TOP (MAIN_PREF_BUTTONS_PANEL_TOP+MAIN_PREF_BUTTONS_PANEL_HEIGHT)
#define MAIN_PREF_EDIT_PANEL_HEIGHT 0.65
#define MAIN_PREF_LIST_PANEL_TOP (MAIN_PREF_EDIT_PANEL_TOP+MAIN_PREF_EDIT_PANEL_HEIGHT*1.0)

#define EDJ_FILE_NAME_PREF_BUTTONS_PANEL "edje/pref_buttons_panel.edj"
#define GROUP_PREF_BUTTONS_PANEL "pref_buttons_panel"
#define PART_PREF_BUTTONS_PANEL_BACKGROUND "pref_buttons_panel_background"
#define PART_PREF_BUTTONS_PANEL_LEFT_BUTTON "pref_buttons_panel_left_button"
#define PART_PREF_BUTTONS_PANEL_RIGHT_BUTTON "pref_buttons_panel_right_button"

#define PART_PREF_BUTTONS_PANEL_BUTTONS_TOP 0.05
#define PART_PREF_BUTTONS_PANEL_BUTTONS_HEIGHT (1.0-PART_PREF_BUTTONS_PANEL_BUTTONS_TOP)
#define PART_PREF_BUTTONS_PANEL_BUTTONS_MARGIN_H MAIN_BACKGROUND_MARGIN_H

#define EDJ_FILE_NAME_PREF_EDIT_PANEL "edje/pref_edit_panel.edj"
#define GROUP_PREF_EDIT_PANEL "pref_edit_panel"
#define PART_PREF_EDIT_PANEL_BACKGROUND "pref_edit_panel_background"
#define PART_PREF_EDIT_PANEL_KEY_PANEL "pref_edit_panel_key_panel"
#define PART_PREF_EDIT_PANEL_KEY_PANEL_ENTRY "pref_edit_panel_key_panel_entry"
#define PART_PREF_EDIT_PANEL_KEY_PANEL_ENTRY_BACKGROUND "pref_edit_panel_key_panel_entry_background"
#define PART_PREF_EDIT_PANEL_VALUE_PANEL "pref_edit_panel_value_panel"
#define PART_PREF_EDIT_PANEL_VALUE_PANEL_ENTRY "pref_edit_panel_value_panel_entry"
#define PART_PREF_EDIT_PANEL_VALUE_PANEL_ENTRY_BACKGROUND "pref_edit_panel_value_panel_entry_background"
#define PART_PREF_EDIT_PANEL_TYPE_PANEL "pref_edit_panel_type_panel"
#define PART_PREF_EDIT_PANEL_TYPE_PANEL_ENTRY "pref_edit_panel_type_panel_entry"

#define PREF_EDIT_PANEL_KEY_PANEL_TOP 0.0
#define PREF_EDIT_PANEL_KEY_PANEL_HEIGHT 0.25
#define PREF_EDIT_PANEL_KEY_PANEL_LABEL_WIDTH 0.3

#define PREF_EDIT_PANEL_VALUE_PANEL_TOP (PREF_EDIT_PANEL_KEY_PANEL_TOP+PREF_EDIT_PANEL_KEY_PANEL_HEIGHT)
#define PREF_EDIT_PANEL_VALUE_PANEL_HEIGHT 0.25
#define PREF_EDIT_PANEL_VALUE_PANEL_LABEL_WIDTH 0.3

#define PREF_EDIT_PANEL_TYPE_PANEL_TOP (PREF_EDIT_PANEL_VALUE_PANEL_TOP+PREF_EDIT_PANEL_VALUE_PANEL_HEIGHT)
#define PREF_EDIT_PANEL_TYPE_PANEL_HEIGHT 0.5
#define PREF_EDIT_PANEL_TYPE_PANEL_LABEL_WIDTH 0.3

#define PREF_EDIT_PANEL_ENTRY_FIELD_HEIGHT 0.7
#define PREF_EDIT_PANEL_ENTRY_FIELD_TOP ((1.0-PREF_EDIT_PANEL_ENTRY_FIELD_HEIGHT)/2)

#endif
