/*
* Copyright (c) 2011 Samsung Electronics Co., Ltd All Rights Reserved
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

#ifndef __helper_H__
#define __helper_H__

#include <glib.h>
#include "$(appName).h"
#include <media_controller_client.h>

void mcs_create_client(appdata_s *ad);
void mcs_destroy_client(appdata_s *ad);
void mcs_set_callback(appdata_s *ad);
void mcs_unset_callback(appdata_s *ad);

void mcs_get_latest_server(appdata_s *ad);
void mcs_get_server_list(appdata_s *ad);
void mcs_get_information(appdata_s *ad, const char *server_name);

void mcs_send_playback_action(appdata_s *ad, const char *server_name, int action);
void mcs_send_playback_position(appdata_s *ad, const char *server_name, unsigned long long position);
void mcs_send_playlist_cmd(appdata_s *ad, const char *server_name, const char *index);
void mcs_send_shuffle(appdata_s *ad, const char *server_name, int shuffle_mode);
void mcs_send_repeat(appdata_s *ad, const char *server_name, int repeat_mode);
void mcs_send_custom_cmd(appdata_s *ad, const char *server_name, const char *command);
void mcs_send_event_reply(appdata_s *ad, const char *server_name, const char *request_id, int result_code);

#endif /* __helper_H__ */
