/*
 * Copyright (c) 2014 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __log_H__
#define __log_H__

#include <dlog.h>

#ifdef  LOG_TAG
#undef  LOG_TAG
#endif
#define LOG_TAG "$(appName)"

#define LOG_DBG(fmt, arg...) do { \
		dlog_print(DLOG_DEBUG, LOG_TAG, "\033[0m"""fmt"", ##arg); \
	} while (0)

#define LOG_INFO(fmt, arg...) do { \
		dlog_print(DLOG_DEBUG, LOG_TAG, "\033[32m"""fmt"""\033[0m", ##arg); \
	} while (0)

#define LOG_ERR(fmt, arg...) do { \
		dlog_print(DLOG_ERROR, LOG_TAG, "\033[32m"""fmt"""\033[0m", ##arg); \
	} while (0)

#define DEBUG_ENTER() do { \
		dlog_print(DLOG_DEBUG, LOG_TAG, "\033[33m""<Enter> %s""\033[0m", __FUNCTION__); \
	} while (0)

#define DEBUG_LEAVE() do { \
		dlog_print(DLOG_DEBUG, LOG_TAG, "\033[33m""<Leave> %s""\033[0m", __FUNCTION__); \
	} while (0)

#define RETM_IF(expr, fmt, arg...) do { \
		if (expr) { \
			dlog_print(DLOG_ERROR, LOG_TAG, ""fmt"", ##arg); \
			return; \
		} \
	} while (0)

#define RETVM_IF(expr, val, fmt, arg...) do { \
		if (expr) { \
			dlog_print(DLOG_ERROR, LOG_TAG, ""fmt"", ##arg); \
			return (val); \
		} \
	} while (0)

#define SAFE_FREE(src) { if (src) {free(src); src = NULL; } }

#endif /* __log_H__ */
