/*
 * Copyright (c) 2014 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#if !defined(_$(appNameUpper)_H_)
#define _$(appNameUpper)_H_

#include <app.h>
#include <system_settings.h>
#include <Elementary.h>
#include <efl_extension.h>
#include <glib.h>

#define IMAGE_MAX 10
#define SLIDE_INTERVAL 1.5

#if !defined(PACKAGE)
#define PACKAGE "$(packageName)"
#endif

#ifdef  LOG_TAG
#undef  LOG_TAG
#endif
#define LOG_TAG "$(appName)"

typedef enum {
	LATEST_SERV_NAME = 0,
	LATEST_SERV_STATE,
	LAST_LATEST_ITEM
} latest_item_e;

/* playback objects on view */
typedef enum {
	PLAYBACK_STATE,
	PLAYBACK_POSITION,
	PLAYBACK_INDEX,
	PLAYBACK_SHUFFLE,
	PLAYBACK_REPEAT,
	LAST_PLAYBACK_ITEM
} playback_item_e;

/* metadata objects on view */
typedef enum {
	META_TITLE,
	META_ARTIST,
	META_ALBUM,
	META_AUTHOR,
	META_GENRE,
	META_DURATION,
	META_DATE,
	META_COPYRIGHT,
	META_DESCRIPTION,
	META_TRACK_NUM,
	META_PICTURE,
	LAST_META_ITEM
} metadata_item_e;

/* custom objects on view */
typedef enum {
	CMD_PLAYBACK_ACTION,
	CMD_SHUFFLE,
	CMD_REPEAT,
	CMD_PLAYBACK_POSITION,
	CMD_PLAYLIST_INDEX,
	LAST_CMD_ITEM
} cmd_item_e;

typedef enum custom_item_e {
	CUSTOM_COMMAND,
	CUSTOM_COMMAND_REPLY,
	CUSTOM_EVENT,
	LAST_CUSTOM_ITEM
} custom_item_e;

/* playlist objects on view */
typedef enum {
	PLAYLIST_NAME = 0,
	PLAYLIST_INDEX,
	PLAYLIST_LIST,
	LAST_PLAYLIST_ITEM
} playlist_item_e;

/* component of each object on view */
typedef struct component {
	unsigned int row;
	Evas_Object *category;
	Evas_Object *label;
	Evas_Object *obj;
} component_s;

/* component of each object on playlist view */
typedef struct component_playlist {
	Evas_Object *layout;
	Evas_Object *index;
	Evas_Object *artist;
	Evas_Object *title;
} component_playlist_s;

/* elements of content_view on view */
typedef struct content_view {
	Evas_Object *layout;
	component_s lat_item[LAST_LATEST_ITEM];
	component_s sl_item;
	component_s pb_item[LAST_PLAYBACK_ITEM];
	component_s meta_item[LAST_META_ITEM];
	component_s cmd_item[LAST_CMD_ITEM];
	component_s custom_item[LAST_CUSTOM_ITEM];
	component_s pl_item[LAST_PLAYLIST_ITEM];
	GList *playlist;
} content_view_s;

/* playlist elements of content_view on view */
typedef struct playlist {
	char *index;
	char *metadata[LAST_META_ITEM];
} playlist_s;

/* server information from media-controller */
typedef struct server_info {
	char *server_name;
	/* playback info */
	unsigned int playback_state;
	unsigned long long playback_position;
	char *playlist_index;
	unsigned int shuffle;
	unsigned int repeat;

	/* metadata info */
	char *metadata[LAST_META_ITEM];

	/* playlist info */
	char *playlist_name;
	GList *playlist;
} server_info_s;

/* server information from media-controller */
typedef struct mc_data {
	/* handle */
	void *handle;

	/* for application state */
	server_info_s server_info;

	/* for activated server list */
	GList *server_list;
	unsigned int server_num;

	/* for activated server list */
	char *latest_server_name;
	int latest_server_state;

	/* for the custom event */
	char *custom_event;
	/* for the result code for the custom event */
	int custom_event_result;

	/* for commands */
	GList *req_ids;
	int cmd_result;
} mc_data_s;

typedef struct appdata {
	Evas_Object *win;
	Evas_Object *conform;
	Evas_Object *layout;
	Evas_Object *nf;

	content_view_s content_view;
	mc_data_s mc_data;
} appdata_s;

#endif
