/*
 * Copyright (c) 2014 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#if !defined(_VIEW_H)
#define _VIEW_H

#include <Elementary.h>
#include <efl_extension.h>
#include "$(appName).h"

Eina_Bool view_create(void *user_data);
Evas_Object *view_create_win(const char *pkg_name);
Evas_Object *view_create_layout(Evas_Object *parent, const char *file_path, const char *group_name, Eext_Event_Cb cb_function, void *user_data);
Evas_Object *view_create_conformant_without_indicator(Evas_Object *win);
void view_destroy(void);
void view_destroy_layout(Evas_Object *layout);

#define LABEL_COLS		2
#define FULL_COLS		3
#define ITEM_CATEGORY	0

#define USER_STYLE_LABEL	"DEFAULT='font=Tizen:style=Regular font_size=25 align=left'"
#define USER_STYLE_ENTRY	"DEFAULT='font=Tizen:style=Light font_size=25 color=#00f align=left'"
#define _STYLE(t)			(g_strdup_printf("<font_size=25><align=left>%s</align></font_size>", t))

#define SERVER_CHECK(s, t)	((s) ? t : NULL)

static const char *hover_items_server_state[] = {
		"STATE_NONE",
		"STATE_ACTIVATE",
		"STATE_DEACTIVATE",
};

static const char *hover_items_playback_state[] = {
		"NONE",
		"PLAYING",
		"PAUSED",
		"STOPPED",
		"MOVING TO NEXT",
		"MOVING TO PREVIOUS",
		"FAST FORWARDING",
		"REWINDING",
		NULL,
};

static const char *hover_items_playback_action[] = {
		"PLAY",
		"PAUSE",
		"STOP",
		"NEXT",
		"PREVIOUS",
		"FAST FORWARD",
		"REWIND",
		"TOGGLE PLAY/PAUSE",
		NULL,
};

static const char *hover_items_playback_position[] = {
		"1000",
		"2000",
		"3000",
		"10000",
		"100000",
		NULL,
};

static const char *hover_items_shuffle[] = {
		"ON",
		"OFF",
		NULL,
};

static const char *hover_items_repeat[] = {
		"ALL",
		"OFF",
		"ONE",
		NULL,
};

static const char *hover_items_custom_cmd[] = {
		"COMMAND1",
		"COMMAND2",
		"COMMAND3",
		NULL,
};

static const char *label_category[] = {
		"Playback",
		"Metadata",
		"Command",
		"Custom",
		NULL,
};

static const char *label_metadata[] = {
		"Title",
		"Artist",
		"Album",
		"Author",
		"Genre",
		"Duration",
		"Date",
		"Copyright",
		"Description",
		"Track Number",
		"Picture",
		NULL,
};

static const char *label_command[] = {
		"Action",
		"Shuffle",
		"Repeat",
		"Position",
		"Playlist Index",
		NULL,
};

static const char *label_custom[] = {
		"Command",
		"Reply",
		"Event",
		NULL,
};

static const unsigned int hover_item_num_playback_action = (sizeof(hover_items_playback_action) / sizeof(char *));
static const unsigned int hover_item_num_playback_position = (sizeof(hover_items_playback_position) / sizeof(char *));
static const unsigned int hover_item_num_shuffle = (sizeof(hover_items_shuffle) / sizeof(char *));
static const unsigned int hover_item_num_repeat = (sizeof(hover_items_repeat) / sizeof(char *));
static const unsigned int hover_item_num_custom_cmd = (sizeof(hover_items_custom_cmd) / sizeof(char *));

Evas_Object* mcs_create_content_view(appdata_s *ad, Evas_Object *parent);

void mcs_update_view_server_list(appdata_s *ad);
void mcs_update_view_latest_server(appdata_s *ad);
void mcs_update_view_information(appdata_s *ad);
void mcs_update_view_playback(appdata_s *ad);
void mcs_update_view_metadata(appdata_s *ad);
void mcs_update_view_command_reply(appdata_s *ad);
void mcs_clear_view_command_reply(appdata_s *ad);
void mcs_update_view_custom_event(appdata_s *ad);
void mcs_update_playlist_view(appdata_s *ad);
void mcs_remove_playlist_view(appdata_s *ad);

#endif
