/*
* Copyright (c) 2011 Samsung Electronics Co., Ltd All Rights Reserved
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

#ifndef __mccserver_H__
#define __mccserver_H__

#include <glib.h>
#include <media_controller_server.h>
#include "$(appName).h"

void mcs_create_server(appdata_s *ad);
void mcs_destroy_server(appdata_s *ad);
void mcs_set_callback(appdata_s *ad);
void mcs_unset_callback(appdata_s *ad);

void mcs_update_playback(appdata_s *ad);
void mcs_update_metadata(appdata_s *ad);
void mcs_update_shuffle(appdata_s *ad);
void mcs_update_repeat(appdata_s *ad);
void mcs_update_playlist(appdata_s *ad);

void mcs_send_cmd_reply(appdata_s *ad, const char *client_name, const char *request_id, int result_code);

void mcs_get_client_list(appdata_s *ad);
void mcs_send_custom_event(appdata_s *ad, const char *client_name, const char *event_name);

#endif /* __mccserver_H__ */
