/*
 * Copyright (c) 2014 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#if !defined(_$(appNameUpper)_H_)
#define _$(appNameUpper)_H_

#include <app.h>
#include <Elementary.h>
#include <system_settings.h>
#include <efl_extension.h>
#include <glib.h>

#define IMAGE_MAX 10
#define SLIDE_INTERVAL 1.5

#define METADATA_MAX 10

#if !defined(PACKAGE)
#define PACKAGE "$(packageName)"
#endif

#ifdef  LOG_TAG
#undef  LOG_TAG
#endif
#define LOG_TAG "$(appName)"

/* playback objects on view */
typedef enum playback_item_e {
	PLAYBACK_STATE,
	PLAYBACK_POSITION,
	PLAYBACK_INDEX,
	PLAYBACK_SHUFFLE,
	PLAYBACK_REPEAT,
	LAST_PLAYBACK_ITEM
} playback_item_e;

/* metadata objects on view */
typedef enum metadata_item_e {
	META_TITLE,
	META_ARTIST,
	META_ALBUM,
	META_AUTHOR,
	META_GENRE,
	META_DURATION,
	META_DATE,
	META_COPYRIGHT,
	META_DESCRIPTION,
	META_TRACK_NUM,
	META_PICTURE,
	LAST_META_ITEM
} metadata_item_e;

/* custom objects on view */
typedef enum custom_item_e {
	CUSTOM_EVENT,
	CUSTOM_EVENT_REPLY,
	CUSTOM_COMMAND,
	LAST_CUSTOM_ITEM
} custom_item_e;

/* playlist objects on view */
typedef enum {
	PLAYLIST_NAME = 0,
	PLAYLIST_INDEX,
	PLAYLIST_LIST,
	LAST_PLAYLIST_ITEM
} playlist_item_e;

/* component of each object on view */
typedef struct component {
	Evas_Object *label;
	Evas_Object *obj;
} component_s;

/* elements of content_view on view */
typedef struct content_view {
	Evas_Object *layout;
	component_s meta_item[LAST_META_ITEM];
	component_s pb_item[LAST_PLAYBACK_ITEM];
	component_s custom_item[LAST_CUSTOM_ITEM];
	component_s pl_item[LAST_PLAYLIST_ITEM];
} content_view_s;

/* playlist elements of content_view on view */
typedef struct playlist {
	char *index;
	char *metadata[LAST_META_ITEM];
} playlist_s;

/* server information from media-controller */
typedef struct server_info {
	/* playback info */
	unsigned int pb_state;
	unsigned long long pb_position;
	char *playlist_index;
	unsigned int shuffle;
	unsigned int repeat;

	/* metadata info */
	char *metadata[LAST_META_ITEM];

	/* playlist info */
	char *playlist_name;
	GList *playlist;
	unsigned int playlist_item_num;

	/* local info */
	int cur_playing_idx;
} server_info_s;

/* server information from media-controller */
typedef struct mc_data {
	/* handle */
	void *handle;

	/* for application state */
	server_info_s server_info;

	/* for activated client list */
	GList *client_list;
	unsigned int client_num;

	/* for custom commands */
	char *custom_cmd;
	/* result code */
	int custom_cmd_result;

	/* for custom events */
	GList *req_ids;
	int event_result;
} mc_data_s;

typedef struct appdata {
	Evas_Object *win;
	Evas_Object *conform;
	Evas_Object *layout;
	Evas_Object *nf;

	content_view_s content_view;
	mc_data_s mc_data;
} appdata_s;

#define PLAYLIST_SAMPLE_NAME "playlist_sample"
#define PLAYLIST_SAMPLE_NUM 9

/* playlist sample for this sample application */
static playlist_s sample_playlist[PLAYLIST_SAMPLE_NUM] = {
		{"1", { "Sample1", "Various", "Sample", "Tizen", "POP", "210000", "2010-10-20", "Open Source", "SAMPLE", "1/9", NULL, } },
		{"2", { "Sample2", "Various", "Sample", "Tizen", "BALLAD", "220000", "2010-10-20", "Open Source", "SAMPLE", "2/9", NULL, } },
		{"3", { "Sample3", "Various", "Sample", "Tizen", "HIP-HOP", "230000", "2010-10-20", "Open Source", "SAMPLE", "3/9", NULL, } },
		{"4", { "Sample4", "Various", "Sample", "Tizen", "CLASSIC", "240000", "2010-10-20", "Open Source", "SAMPLE", "4/9", NULL, } },
		{"5", { "Sample5", "Various", "Sample", "Tizen", "ROCK", "250000", "2010-10-20", "Open Source", "SAMPLE", "5/9", NULL, } },
		{"6", { "Sample6", "Various", "Sample", "Tizen", "KPOP", "260000", "2010-10-20", "Open Source", "SAMPLE", "6/9", NULL, } },
		{"7", { "Sample7", "Various", "Sample", "Tizen", "COUNTRY", "270000", "2010-10-20", "Open Source", "SAMPLE", "7/9", NULL, } },
		{"8", { "Sample8", "Various", "Sample", "Tizen", "DISCO", "280000", "2010-10-20", "Open Source", "SAMPLE", "8/9", NULL, } },
		{"9", { "Sample9", "Various", "Sample", "Tizen", "JAZZ", "290000", "2010-10-20", "Open Source", "SAMPLE", "9/9", NULL, } },
};

#endif
