/*
 * Copyright (c) 2014 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#if !defined(_VIEW_H)
#define _VIEW_H

#include <Elementary.h>
#include <efl_extension.h>
#include "$(appName).h"

#define LABEL_COLS 2
#define FULL_COLS 3

#define USER_STYLE_LABEL	"DEFAULT='font=Tizen:style=Regular font_size=25 align=left'"
#define USER_STYLE_ENTRY	"DEFAULT='font=Tizen:style=Light font_size=25 color=#00f align=left'"
#define _STYLE(t)			(g_strdup_printf("<font_size=25><align=left>%s</align></font_size>", t))

static const char *hover_items_pb_state[] = {
		"NONE",
		"PLAYING",
		"PAUSED",
		"STOPPED",
		"MOVING TO NEXT",
		"MOVING TO PREVIOUS",
		"FAST FORWARDING",
		"REWINDING",
		NULL,
};

static const char *hover_items_pb_position[] = {
		"1000",
		"2000",
		"3000",
		"4000",
		"5000",
		"6000",
		"7000",
		"8000",
		"9000",
		NULL,
};

static const char *hover_items_shuffle[] = {
		"ON",
		"OFF",
		NULL,
};

static const char *hover_items_repeat[] = {
		"ALL",
		"OFF",
		"ONE",
		NULL,
};

static const char *hover_items_event[] = {
		"EVENT1",
		"EVENT2",
		"EVENT3",
		NULL,
};

static const char *label_category[] = {
		"Metadata",
		"Playback",
		"Custom",
		"Playlist",
		NULL,
};

static const char *label_metadata[] = {
		"Title",
		"Artist",
		"Album",
		"Author",
		"Genre",
		"Duration",
		"Date",
		"Copyright",
		"Description",
		"Track Number",
		"Picture",
		NULL,
};

static const char *label_custom[] = {
		"Event",
		"Reply",
		"Command",
		NULL,
};

Eina_Bool view_create(void *user_data);
Evas_Object *view_create_win(const char *pkg_name);
Evas_Object *view_create_layout(Evas_Object *parent, const char *file_path, const char *group_name, Eext_Event_Cb cb_function, void *user_data);
Evas_Object *view_create_conformant_without_indicator(Evas_Object *win);
void view_destroy(void);
void view_destroy_layout(Evas_Object *layout);

static const unsigned int hover_item_num_pb_state = (sizeof(hover_items_pb_state) / sizeof(char *));
static const unsigned int hover_item_num_pb_position = (sizeof(hover_items_pb_position) / sizeof(char *));
static const unsigned int hover_item_num_shuffle = (sizeof(hover_items_shuffle) / sizeof(char *));
static const unsigned int hover_item_num_repeat = (sizeof(hover_items_repeat) / sizeof(char *));
static const unsigned int hover_item_num_event = (sizeof(hover_items_event) / sizeof(char *));

Evas_Object * mcs_create_content_view(appdata_s *ad, Evas_Object *parent);

void mcs_update_view_playback(appdata_s *ad);
void mcs_update_view_metadata(appdata_s *ad);
void mcs_update_view_metadata_by_index(appdata_s *ad, const char *index);
void mcs_update_view_custom_command(appdata_s *ad);
void mcs_update_view_event_reply(appdata_s *ad);
void mcs_clear_view_event_reply(appdata_s *ad);

#endif
