/*
 *      Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 *      Licensed under the Flora License, Version 1.1 (the "License");
 *      you may not use this file except in compliance with the License.
 *      You may obtain a copy of the License at
 *
 *              http://floralicense.org/license/
 *
 *      Unless required by applicable law or agreed to in writing, software
 *      distributed under the License is distributed on an "AS IS" BASIS,
 *      WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *      See the License for the specific language governing permissions and
 *      limitations under the License.
 */

/*global pageMonthly, pageDaily, pageHistory, util*/

(function() {

    /**
     * Handles the back key event
     * @private
     */
    function keyEventHandler(event) {
        var page = null;
        if (event.keyName === "back") {
            page = pageHistory.pop();
            page.hide();
            page = pageHistory.getCurrentPage();
            if (page) {
                page.show();
            } else {
                try {
                    tizen.application.getCurrentApplication().exit();
                } catch (ignore) {}
            }
        }
    }

    /**
     * Initializes the application
     * @private
     */
    function init() {
        var reqAppControl, events;

        events = util.getEvents();
        // Sets the preference value to events data to share with the schedule widget
        tizen.preference.setValue('events', JSON.stringify(events));
        // Gets the requested application control passed to the current application.
        reqAppControl = tizen.application.getCurrentApplication().getRequestedAppControl();

        if (reqAppControl && reqAppControl.appControl.operation === 'schedule/daily') {
            pageDaily.activate();
        } else {
            pageMonthly.activate();
        }

        // Apply circular scrollbar
        document.getElementById('page-daily').setAttribute("tizen-circular-scrollbar", "");
        document.getElementById('page-detail').setAttribute("tizen-circular-scrollbar", "");
        window.addEventListener('tizenhwkey', keyEventHandler);
    }

    window.onload = init();
}());
